<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class About_model extends CI_Model
{
    public function get_single_about()
    {
        return $this->db->limit(1)->get('about_details')->row();
    }
    public function add_about_details($data)
    {
        $this->db->insert('about_details', $data);
        return $this->db->insert_id();
    }

    public function get_all()
    {
        $this->db->order_by('id', 'desc');
        return $this->db->get('about_details')->result();
    }

    public function update_about_details($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('about_details', $data);
    }

    public function get_about_details_by_id($id)
    {
        $this->db->where('id', $id);
        return $this->db->get('about_details')->row();
    }

    public function delete_about_details($id)
    {
        // Step 1: Get all image filenames from database
        $this->db->select('featured_image_one, featured_image_two');
        $this->db->from('about_details');
        $this->db->where('id', $id);
        $query = $this->db->get();
        $row = $query->row();

        // Step 2: Delete each image if it exists
        if (!empty($row)) {
            $images = [
                $row->featured_image_one,
                $row->featured_image_two,
            ];

            foreach ($images as $img) {
                if (!empty($img)) {
                    $image_path = FCPATH . $img; // Full path
                    if (file_exists($image_path)) {
                        unlink($image_path); // Delete image file
                    }
                }
            }
        }

        // Step 3: Delete record from database
        $this->db->where('id', $id);
        $this->db->delete('about_details');

        // Step 4: Return number of affected rows
        return $this->db->affected_rows();
    }

    // chairman note

    public function get_single_chairman_note()
    {
        return $this->db->limit(1)->get('chairman_note')->row();
    }
    public function add_chairman_note($data)
    {
        $this->db->insert('chairman_note', $data);
        return $this->db->insert_id();
    }

    public function update_chairman_note($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('chairman_note', $data);
    }

    public function get_all_chairman_note()
    {
        $this->db->order_by('id', 'desc');
        return $this->db->get('chairman_note')->result();
    }



    public function get_chairman_note_by_id($id)
    {
        $this->db->where('id', $id);
        return $this->db->get('chairman_note')->row();
    }

    public function delete_chairman_note($id)
    {
        // Step 1: Get all image filenames from database
        $this->db->select('featured_image');
        $this->db->from('chairman_note');
        $this->db->where('id', $id);
        $query = $this->db->get();
        $row = $query->row();

        // Step 2: Delete each image if it exists
        if (!empty($row)) {
            $images = [
                $row->featured_image,
            ];

            foreach ($images as $img) {
                if (!empty($img)) {
                    $image_path = FCPATH . $img; // Full path
                    if (file_exists($image_path)) {
                        unlink($image_path); // Delete image file
                    }
                }
            }
        }

        // Step 3: Delete record from database
        $this->db->where('id', $id);
        $this->db->delete('chairman_note');

        // Step 4: Return number of affected rows
        return $this->db->affected_rows();
    }

    // operational_model

    public function get_single_operational_model()
    {
        return $this->db->limit(1)->get('operational_model')->row();
    }
    public function add_operational_model($data)
    {
        $this->db->insert('operational_model', $data);
        return $this->db->insert_id();
    }

    public function update_operational_model($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('operational_model', $data);
    }

    public function get_all_operational_model()
    {
        $this->db->order_by('id', 'desc');
        return $this->db->get('operational_model')->result();
    }



    public function get_operational_model_by_id($id)
    {
        $this->db->where('id', $id);
        return $this->db->get('operational_model')->row();
    }

    public function delete_operational_model($id)
    {
        // Step 1: Get all image filenames from database
        $this->db->select('featured_image');
        $this->db->from('operational_model');
        $this->db->where('id', $id);
        $query = $this->db->get();
        $row = $query->row();

        // Step 2: Delete each image if it exists
        if (!empty($row)) {
            $images = [
                $row->featured_image,
            ];

            foreach ($images as $img) {
                if (!empty($img)) {
                    $image_path = FCPATH . $img; // Full path
                    if (file_exists($image_path)) {
                        unlink($image_path); // Delete image file
                    }
                }
            }
        }

        // Step 3: Delete record from database
        $this->db->where('id', $id);
        $this->db->delete('operational_model');

        // Step 4: Return number of affected rows
        return $this->db->affected_rows();
    }

}