<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Job_model extends CI_Model
{
    public function add_job_post($data)
    {
        $this->db->insert('job_post', $data);
        if ($this->db->affected_rows() > 0) {
            return $this->db->insert_id(); // return insert ID
        } else {
            return false;
        }
    }
    public function get_all()
    {
        $this->db->order_by('id', 'desc');
        return $this->db->get('job_post')->result();
    }

    public function get_job_post_by_id($id)
    {
        $this->db->where('id', $id);
        return $this->db->get('job_post')->row();
    }

    public function update_job_post($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('job_post', $data);
    }

    public function set_status($id)
    {
        // Get current status
        $this->db->select('status');
        $this->db->from('job_post');
        $this->db->where('id', $id);
        $blog = $this->db->get()->row();

        if ($blog) {
            // Toggle status
            $new_status = ($blog->status == 'active') ? 'inactive' : 'active';

            // Update status in database
            $this->db->where('id', $id);
            $this->db->update('job_post', ['status' => $new_status]);

            return $new_status; // return new status to controller
        }

        return false; // blog not found
    }
    
     public function submit_application($data)
    {
        return $this->db->insert('job_applications', $data);
    }
    
     public function get_applications()
    {
        $this->db->select('job_applications.*, job_post.position_name, job_post.job_location');
        $this->db->from('job_applications');
        $this->db->join('job_post', 'job_applications.job_id = job_post.id', 'left');
        $this->db->order_by('job_applications.id', 'DESC');
        return $this->db->get()->result();
    }
    
    public function get_applications_by_id($id)
    {
        $this->db->select('job_applications.*, job_post.position_name, job_post.job_location');
        $this->db->from('job_applications');
        $this->db->join('job_post', 'job_applications.job_id = job_post.id', 'left');
        $this->db->where('job_applications.id', $id);
        return $this->db->get()->row();
    }
    
    public function delete_application($id)
    {
        // 🔹 Pehle record fetch karo taaki file path mil sake
        $application = $this->db->get_where('job_applications', ['id' => $id])->row();

        if ($application) {
            // 🔹 File path check & delete
            $file_path = FCPATH . $application->resume; // full local path ban gaya
            if (file_exists($file_path)) {
                unlink($file_path);
            }

            // 🔹 Ab database se delete karo
            $this->db->where('id', $id);
            $this->db->delete('job_applications');

            return $this->db->affected_rows();
        }

        return 0;
    }

}