<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Membership_eligibility_model extends CI_Model
{
    // Fetch first record
    public function get_membership_eligibility()
    {
        return $this->db->get('membership_eligibility')->row();
    }

    // Update by ID
    public function update_membership_eligibility($id, $data)
    {
        return $this->db->where('id', $id)->update('membership_eligibility', $data);
    }

    // Add new
    public function add_membership_eligibility($data)
    {
        $this->db->insert('membership_eligibility', $data);
        return $this->db->insert_id();
    }

    public function get_all()
    {
        $this->db->order_by('id', 'desc');
        return $this->db->get('membership_eligibility')->result();
    }

    public function get_membership_eligibility_by_id($id)
    {
        $this->db->where('id', $id);
        return $this->db->get('membership_eligibility')->row();
    }


    public function delete_membership_eligibility($id)
    {
        // Step 1: Get all image filenames from database
        $this->db->select('featured_image_one, featured_image_two, pdf');
        $this->db->from('membership_eligibility');
        $this->db->where('id', $id);
        $query = $this->db->get();
        $row = $query->row();

        // Step 2: Delete each image if it exists
        if (!empty($row)) {
            $images = [
                $row->featured_image_one,
                $row->featured_image_two,
                $row->pdf,
            ];

            foreach ($images as $img) {
                if (!empty($img)) {
                    $image_path = FCPATH . $img; // Full path
                    if (file_exists($image_path)) {
                        unlink($image_path); // Delete image file
                    }
                }
            }
        }

        // Step 3: Delete record from database
        $this->db->where('id', $id);
        $this->db->delete('membership_eligibility');

        // Step 4: Return number of affected rows
        return $this->db->affected_rows();
    }

}