<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Product_model extends CI_Model
{
    public function add_product($data)
    {
        $this->db->insert('product', $data);
        if ($this->db->affected_rows() > 0) {
            return $this->db->insert_id(); // return insert ID
        } else {
            return false;
        }
    }

    public function get_all_product()
    {
        $this->db->order_by('id', 'desc');
        return $this->db->get('product')->result();
    }

    public function get_product_by_id($id)
    {
        $this->db->where('id', $id);
        return $this->db->get('product')->row();
    }

    public function update_product($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('product', $data);
    }

    public function delete_product($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('product');
        return $this->db->affected_rows();
    }

    public function add_product_details($data)
    {
        $this->db->insert('product_details', $data);
        return $this->db->insert_id();
    }

    public function get_all_product_details()
    {
        $this->db->order_by('id', 'desc');
        return $this->db->get('product_details')->result();
    }

    public function get_product_details_by_id($id)
    {
        $this->db->where('id', $id);
        return $this->db->get('product_details')->row();
    }

    public function get_product_details($id)
    {
        return $this->db->get_where('product_details', ['id' => $id])->row();
    }

    public function update_product_details($id, $data)
    {
        return $this->db->where('id', $id)->update('product_details', $data);
    }


    public function delete_product_details($id)
    {
        // Step 1: Get all image filenames from database
        $this->db->select('featured_image_one, featured_image_two, featured_image_three');
        $this->db->from('product_details');
        $this->db->where('id', $id);
        $query = $this->db->get();
        $row = $query->row();

        // Step 2: Delete each image if it exists
        if (!empty($row)) {
            $images = [
                $row->featured_image_one,
                $row->featured_image_two,
                $row->featured_image_three
            ];

            foreach ($images as $img) {
                if (!empty($img)) {
                    $image_path = FCPATH . $img; // Full path
                    if (file_exists($image_path)) {
                        unlink($image_path); // Delete image file
                    }
                }
            }
        }
    }
    public function get_product_details_by_slug($slug)
    {
        $this->db->select('product.slug, product_details.*');
        $this->db->from('product_details');
        $this->db->join('product', 'product_details.product_name = product.product');
        $this->db->where('product.slug', $slug);
        return $this->db->get()->row(); // use result() if multiple rows
    }
    
    public function get_all_product_category()
    {
        $this->db->select('product_details.*, product.slug');
        $this->db->from('product_details');
        $this->db->join('product', 'product_details.product_name = product.product');
        $this->db->order_by('product_details.id', 'desc');
        return $this->db->get()->result();
    }


}