<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Section_model extends CI_Model
{
    public function get_section_by_name($section_name)
    {
        $this->db->where('section_name', $section_name);
        $query = $this->db->get('section_access');
        return $query->result();
    }

    public function update_status_by_name($section_name, $status)
    {
        $data = array(
            'status' => $status
        );

        $this->db->where('section_name', $section_name);
        $result = $this->db->update('section_access', $data);

        return $result;
    }

    public function is_active($section_name)
    {
        return $this->db
            ->where('section_name', $section_name)
            ->where('status', 'active')
            ->limit(1)
            ->get('section_access')
            ->num_rows() > 0;
    }
}