<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Service_model extends CI_Model
{
    public function add_service($data)
    {
        $this->db->insert('service', $data);
        if ($this->db->affected_rows() > 0) {
            return $this->db->insert_id(); // return insert ID
        } else {
            return false;
        }
    }

    public function get_all_service()
    {
        $this->db->order_by('id', 'desc');
        return $this->db->get('service')->result();
    }

    public function get_service_by_id($id)
    {
        $this->db->where('id', $id);
        return $this->db->get('service')->row();
    }

    public function update_service($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('service', $data);
    }

    public function delete_service($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('service');
        return $this->db->affected_rows();
    }

    public function add_service_details($data)
    {
        $this->db->insert('service_details', $data);
        return $this->db->insert_id();
    }

    public function get_all_service_details()
    {
        $this->db->order_by('id', 'desc');
        return $this->db->get('service_details')->result();
    }

    public function get_service_details_by_id($id)
    {
        $this->db->where('id', $id);
        return $this->db->get('service_details')->row();
    }

    public function get_service_details($id)
    {
        return $this->db->get_where('service_details', ['id' => $id])->row();
    }

    public function update_service_details($id, $data)
    {
        return $this->db->where('id', $id)->update('service_details', $data);
    }

    public function delete_service_details($id)
    {
        // Step 1: Get all image filenames from database
        $this->db->select('featured_image_one, featured_image_two, featured_image_three');
        $this->db->from('service_details');
        $this->db->where('id', $id);
        $query = $this->db->get();
        $row = $query->row();

        // Step 2: Delete each image if it exists
        if (!empty($row)) {
            $images = [
                $row->featured_image_one,
                $row->featured_image_two,
                $row->featured_image_three
            ];

            foreach ($images as $img) {
                if (!empty($img)) {
                    $image_path = FCPATH . $img; // Full path
                    if (file_exists($image_path)) {
                        unlink($image_path); // Delete image file
                    }
                }
            }
        }

        // Step 3: Delete record from database
        $this->db->where('id', $id);
        $this->db->delete('service_details');

        // Step 4: Return number of affected rows
        return $this->db->affected_rows();
    }


    public function get_service_details_by_slug($slug)
    {
        $this->db->select('service.slug, service_details.*');
        $this->db->from('service_details');
        $this->db->join('service', 'service_details.service_name = service.service');
        $this->db->where('service.slug', $slug);
        return $this->db->get()->row(); // use result() if multiple rows
    }
    
    public function get_all_service_category()
    {
        $this->db->select('service_details.*, service.slug');
        $this->db->from('service_details');
        $this->db->join('service', 'service_details.service_name = service.service');
        $this->db->order_by('service_details.id', 'desc');
        return $this->db->get()->result();
    }

}