<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Slider_model extends CI_Model
{

    public function insert_slider($data)
    {

        return $this->db->insert('slider', $data);
    }


    public function get_all()
    {
        $this->db->order_by('id', 'desc');
        return $this->db->get('slider')->result();
    }



    public function delete_slider($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('slider');
        return $this->db->affected_rows();
    }

    public function set_status($id)
    {
        // Get current status
        $this->db->select('status');
        $this->db->from('slider');
        $this->db->where('id', $id);
        $blog = $this->db->get()->row();

        if ($blog) {
            // Toggle status
            $new_status = ($blog->status == 'active') ? 'inactive' : 'active';

            // Update status in database
            $this->db->where('id', $id);
            $this->db->update('slider', ['status' => $new_status]);

            return $new_status; // return new status to controller
        }

        return false; // blog not found
    }

    public function get_slider_by_id($id)
    {
        $this->db->where('id', $id);
        return $this->db->get('slider')->row();
    }

    public function update_slider($id, $data)
    {
        return $this->db->where('id', $id)->update('slider', $data);
    }

    public function get_all_slider()
    {
        $this->db->where('status', 'active');
        $this->db->order_by('id', 'desc');
        return $this->db->get('slider')->result();
    }
}