<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Testimonial_model extends CI_Model
{

    public function add_testimonials($data)
    {
        $this->db->insert('testimonials', $data);
        return $this->db->insert_id();
    }
    public function get_all()
    {
        $this->db->order_by('id', 'desc');
        return $this->db->get('testimonials')->result();
    }

    public function edit_testimonials($id, $data)
    {
        $this->db->where('id', $id);
        $this->db->update('testimonials', $data);
        return $this->db->affected_rows();
    }
    public function get_testimonials_by_id($id)
    {
        $this->db->where('id', $id);
        return $this->db->get('testimonials')->row();
    }
    public function delete_testimonials($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('testimonials');
        return $this->db->affected_rows();
    }

    public function update_testimonials($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('testimonials', $data);
    }
}