<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="utf-8" />
	<meta name="keywords" content="Maalav Milk - Maalav Milk home page" />
	<meta name="description" content="Maalav Milk - Maalav Milk home page" />
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge" />

	<title><?= $language == 'hi' ? 'हमारे बारे में | मालव दूध' : 'About Us | Maalav Milk' ?></title>
	<?php include_once('common_page/links.php'); ?>
</head>

<body>


	<div id="main-wrapper">
		<?php include_once('common_page/header.php'); ?>
		<main>
			<!-- Breadcum Start -->
			<section class="breadcum v1 bg-cover-center" data-background="assets/img/breadcum/bg.jpg">
				<div class="container">
					<h2> <?= $language == 'hi' ? 'हमारे बारे में' : 'About Us' ?> </h2>
					<ul>
						<li><a href="<?= base_url() ?>"><?= $language == 'hi' ? 'होम' : 'Home' ?></a></li>
						<li><?= $language == 'hi' ? 'हमारे बारे में' : 'About Us' ?></li>
					</ul>
				</div>
			</section>
			<!-- Breadcum End -->
			<!-- About Beeberry Start -->
			<section class="about-beeberry v3">
				<div class="container">
					<?php foreach ($about as $data): ?>
						<div class="row">
							<?php if ($image): ?>
								<div class="col-lg-6">
									<div class="abou-o-img d-flex justify-content-center">
										<div>
											<img src="<?= base_url($data->featured_image_one) ?>" alt="about" class="img1" />
										</div>
										<div>
											<img src="<?= base_url($data->featured_image_two) ?>" alt="about" class="img2" />
										</div>
									</div>
								</div>
							<?php endif; ?>
							<div class="<?php if ($image): ?> col-lg-6 <?php else: ?> col-lg-12 <?php endif; ?>">
								<div class="content-left ps-1">
									<div class="section-title v1">
										<h6><?= $language == 'hi' ? 'हमारे बारे में' : 'About Us' ?></h6>
										<h2><?= $language == 'hi' ? $data->hindi_title : $data->title ?></h2>
										<p>

											<?= $language == 'hi' ? $data->hindi_content : $data->content ?>


										</p>
									</div>

								</div>
							</div>
						</div>
					<?php endforeach; ?>
				</div>
			</section>
			<!-- Blog News End -->
		</main>
		<?php include_once('common_page/footer.php'); ?>
	</div>

	<?php include_once('common_page/script.php'); ?>
</body>

</html>