<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Add About Details | Maalav Milk Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php include_once('common_page/links.php'); ?>
</head>

<body>
    <!-- Begin page -->
    <div class="wrapper">

        <?php include_once('common_page/sidebar.php'); ?>
        <?php include_once('common_page/header.php'); ?>

        <!-- ============================================================== -->
        <!-- Start Main Content -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="container-fluid">
                <div class="page-title-head d-flex align-items-center">
                    <div class="flex-grow-1">
                        <h4 class="fs-xl fw-bold m-0">Add About Details</h4>
                    </div>


                </div>


                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header justify-content-between">
                                <h4 class="card-title">Add About Details</h4>
                            </div>

                            <div class="card-body">
                                <form class="row g-3 needs-validation" id="detailsForm" method="POST"
                                    enctype="multipart/form-data" novalidate>



                                    <!-- ===== Section One ===== -->
                                    <div class="col-md-6">
                                        <label class="form-label">Title</label>
                                        <input type="text" class="form-control" name="title" required>
                                        <span id="error-title_one" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Hindi Title</label>
                                        <input type="text" class="form-control" name="hindi_title" required>
                                        <span id="error-hindi_title_one" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Content</label>
                                        <div id="editor_one" style="height: 300px;"></div>
                                        <input type="hidden" name="content" id="hidden-content-one">
                                        <span id="error-content_one" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Hindi Content</label>
                                        <div id="editor_four" style="height: 300px;"></div>
                                        <input type="hidden" name="hindi_content" id="hidden-hindi-content-one">
                                        <span id="error-hindi_content_one" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-12">
                                        <label class="form-label">Image One</label>
                                        <input type="file" id="featured_image_one" name="featured_image_one"
                                            class="filepond form-control" required>
                                        <span id="error-featured_image_one" class="text-danger error"></span>
                                    </div>

                                    <!-- ===== Section Two ===== -->

                                    <div class="col-md-12">
                                        <label class="form-label">Image Two</label>
                                        <input type="file" id="featured_image_two" name="featured_image_two"
                                            class="filepond form-control" required>
                                        <span id="error-featured_image_two" class="text-danger error"></span>
                                    </div>

                                    <!-- ===== Section Three ===== -->


                                    <div class="col-12">
                                        <button class="btn btn-primary" type="submit">Submit Form</button>
                                    </div>
                                </form>

                            </div> <!-- end card-body-->
                        </div> <!-- end card-->
                    </div>
                </div>



            </div>
            <!-- container -->

            <?php include_once('common_page/footer.php'); ?>


        </div>

        <!-- ============================================================== -->
        <!-- End of Main Content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <?php include_once('common_page/script.php'); ?>


    <script>
        $(document).ready(function () {

            const quill1 = new Quill('#editor_one', { theme: 'snow' });
            const quill4 = new Quill('#editor_four', { theme: 'snow' });

            const pond1 = FilePond.create(document.querySelector('#featured_image_one'));
            const pond2 = FilePond.create(document.querySelector('#featured_image_two'));

            $("#detailsForm").on("submit", function (e) {
                e.preventDefault();
                $(".error").html("");

                $("#hidden-content-one").val(quill1.root.innerHTML);
                $("#hidden-hindi-content-one").val(quill4.root.innerHTML);

                let formData = new FormData(this);

                if (pond1.getFiles().length > 0) {
                    formData.append('featured_image_one', pond1.getFiles()[0].file);
                }

                if (pond2.getFiles().length > 0) {
                    formData.append('featured_image_two', pond2.getFiles()[0].file);
                }

                $.ajax({
                    url: "<?= base_url('admin/about/submit_about_details') ?>",
                    type: "POST",
                    data: formData,
                    contentType: false,
                    processData: false,
                    dataType: "json",

                    success: function (response) {

                        if (response.status === "error") {
                            $.each(response.errors, function (key, val) {
                                $("#error-" + key).html(val);
                            });
                        }

                        if (response.status === "success") {
                            window.location.href = response.redirect;
                        }
                    },
                    error: function (xhr) {
                        console.log(xhr.responseText);
                    }
                });

            });

        });

    </script>




</body>

</html>