<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Add Gallery | Maalav Milk Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php include_once('common_page/links.php'); ?>
</head>

<body>
    <!-- Begin page -->
    <div class="wrapper">

        <?php include_once('common_page/sidebar.php'); ?>
        <?php include_once('common_page/header.php'); ?>

        <!-- ============================================================== -->
        <!-- Start Main Content -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="container-fluid">
                <div class="page-title-head d-flex align-items-center">
                    <div class="flex-grow-1">
                        <h4 class="fs-xl fw-bold m-0">Add Gallery</h4>
                    </div>


                </div>


                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header justify-content-between">
                                <h4 class="card-title">Add Gallery</h4>
                            </div>

                            <div class="card-body">
                                <form class="row g-3 needs-validation" novalidate id="galleryForm" method="POST"
                                    enctype="multipart/form-data">
                                    <div class="col-md-6">
                                        <label for="validationCustom01" class="form-label">Gallery Category</label>
                                        <select name="gallery_category[]" id="validationCustom01" class="form-select">
                                            <option value="">Select Gallery Category</option>
                                            <?php foreach ($category as $data): ?>
                                                <option value="<?= $data->category ?>"><?= $data->category ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="valid-feedback">Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid category.</div>
                                        <span id="error-gallery_category" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="validationCustom02" class="form-label">Hindi Gallery
                                            Category</label>
                                        <select name="hindi_gallery_category[]" id="validationCustom02"
                                            class="form-select">
                                            <option value="">गैलरी केटेगरी चुनें</option>
                                            <?php foreach ($category as $data): ?>
                                                <option value="<?= $data->hindi_category ?>"><?= $data->hindi_category ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="valid-feedback">Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid hindi category.</div>
                                        <span id="error-hindi_gallery_category" class="text-danger error"></span>
                                    </div>
                                     <div class="col-md-6">
                                        <label for="validationCustom03" class="form-label">Year</label>
                                        <input type="number" id="validationCustom03" name="year[]" class="form-control"
                                            maxlength="4"
                                            oninput="if(this.value.length > 4) this.value = this.value.slice(0,4);" />
                                        <div class="valid-feedback">Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid category.</div>
                                        <span id="error-year" class="text-danger error"></span>
                                    </div>
                                    <div>
                                        <h5 class="mb-3">Gallery Images</h5>
                                        <div class="filepond-uploader three-grid">
                                            <input type="file" class="filepond filepond-input-multiple" multiple
                                                name="gallery_image[]" data-allow-reorder="true"
                                                data-max-file-size="3MB" data-max-files="5" required>
                                        </div>
                                        <span id="error-image" class="text-danger error"></span>
                                    </div>

                                    <div class="col-12">
                                        <button class="btn btn-primary" type="submit">Submit Form</button>
                                    </div>
                                </form>



                            </div> <!-- end card-body-->
                        </div> <!-- end card-->
                    </div>
                </div>



            </div>
            <!-- container -->

            <?php include_once('common_page/footer.php'); ?>


        </div>

        <!-- ============================================================== -->
        <!-- End of Main Content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <?php include_once('common_page/script.php'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // Initialize FilePond
            const pond = FilePond.create(document.querySelector('.filepond-input-multiple'), {
                allowMultiple: true,
                maxFiles: 10,
                maxFileSize: '50MB',
                server: null, // no instant upload
                instantUpload: false
            });

            $("#galleryForm").on("submit", function (e) {
                e.preventDefault();
                $(".error").html("");

                var formData = new FormData(this);

                // Append FilePond files with filename (important!)
                pond.getFiles().forEach((file) => {
                    formData.append('gallery_image[]', file.file, file.file.name);
                });

                $.ajax({
                    url: "<?= base_url('admin/gallery/submit_gallery') ?>",
                    type: "POST",
                    data: formData,
                    contentType: false,
                    processData: false,
                    dataType: "json",
                    success: function (response) {
                        if (response.status === "error") {
                            $.each(response.errors, function (key, val) {
                                $("#error-" + key).html(val);
                            });
                        } else if (response.status === "success") {
                            window.location.href = response.redirect;
                        }
                    },
                    error: function (xhr) {
                        console.log(xhr.responseText);
                    }
                });
            });
            $('select[name="gallery_category[]"]').on('change', function () {
                let selectedIndex = $(this).prop('selectedIndex'); // 👈 selected option ka index le lo
                $('select[name="hindi_gallery_category[]"]').prop('selectedIndex', selectedIndex); // 👈 same index select karo
            });
        });
    </script>



</body>

</html>