<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Add Job Post | Maalav Milk Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php include_once('common_page/links.php'); ?>
</head>

<body>
    <!-- Begin page -->
    <div class="wrapper">

        <?php include_once('common_page/sidebar.php'); ?>
        <?php include_once('common_page/header.php'); ?>

        <!-- ============================================================== -->
        <!-- Start Main Content -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="container-fluid">
                <div class="page-title-head d-flex align-items-center">
                    <div class="flex-grow-1">
                        <h4 class="fs-xl fw-bold m-0">Add Job Post</h4>
                    </div>


                </div>


                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header justify-content-between">
                                <h4 class="card-title">Add Job Post</h4>
                            </div>

                            <div class="card-body">
                                <form class="row g-3 needs-validation" id="jobForm" method="POST"
                                    enctype="multipart/form-data" novalidate>
                                    <div class="col-md-6">
                                        <label for="validationCustom01" class="form-label">Position Name</label>
                                        <input type="text" class="form-control" id="validationCustom01"
                                            name="position_name" required>
                                        <div class="valid-feedback">Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Position Name.</div>
                                        <span id="error-position_name" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="validationCustom02" class="form-label">Hindi Position Name</label>
                                        <input type="text" class="form-control" id="validationCustom02"
                                            name="hindi_position_name" required>
                                        <div class="valid-feedback">Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Hindi Position Name.</div>
                                        <span id="error-hindi_category" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="validationCustom03" class="form-label">Job Location</label>
                                        <input type="text" class="form-control" id="validationCustom03"
                                            name="job_location" required>
                                        <div class="valid-feedback">Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Job Location.</div>
                                        <span id="error-job_location" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="validationCustom04" class="form-label">Hindi Job Location</label>
                                        <input type="text" class="form-control" id="validationCustom04"
                                            name="hindi_job_location" required>
                                        <div class="valid-feedback">Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Hindi Job Location.</div>
                                        <span id="error-hindi_job_location" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="validationCustom05" class="form-label">Qualification</label>
                                        <textarea name="qualification" id="validationCustom05"
                                            class="form-control"></textarea>
                                        <div class="valid-feedback">Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Qualification.</div>
                                        <span id="error-qualification" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="validationCustom06" class="form-label">Hindi Qualification</label>
                                        <textarea name="hindi_qualification" id="validationCustom06"
                                            class="form-control"></textarea>
                                        <div class="valid-feedback">Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Hindi Qualification.</div>
                                        <span id="error-hindi_qualification" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="validationCustom07" class="form-label">Job Responsibility/Job
                                            Discription </label>
                                        <textarea name="job_responsibility" id="validationCustom07"
                                            class="form-control"></textarea>
                                        <div class="valid-feedback">Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Job Responsibility.</div>
                                        <span id="error-job_responsibility" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="validationCustom08" class="form-label">Hindi Job
                                            Responsibility/Hindi Job Discription</label>
                                        <textarea name="hindi_job_responsibility" id="validationCustom08"
                                            class="form-control"></textarea>
                                        <div class="valid-feedback">Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Hindi Job Responsibility.
                                        </div>
                                        <span id="error-hindi_job_responsibility" class="text-danger error"></span>
                                    </div>
                                    <div class="col-12">
                                        <button class="btn btn-primary" type="submit">Submit Form</button>
                                    </div>
                                </form>

                            </div> <!-- end card-body-->
                        </div> <!-- end card-->
                    </div>
                </div>



            </div>
            <!-- container -->

            <?php include_once('common_page/footer.php'); ?>


        </div>

        <!-- ============================================================== -->
        <!-- End of Main Content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <?php include_once('common_page/script.php'); ?>


    <script>
        $(document).ready(function () {

            $("#jobForm").on("submit", function (e) {
                e.preventDefault(); // prevent page reload
                $(".error").html(""); // clear old errors

                // Create FormData object
                var formData = new FormData(this);

                $.ajax({
                    url: "<?= base_url('admin/job_post/submit_job_post') ?>",
                    type: "POST",
                    data: formData,
                    contentType: false,
                    processData: false,
                    dataType: "json",
                    success: function (response) {
                        if (response.status === "error") {
                            $.each(response.errors, function (key, val) {
                                $("#error-" + key).html(val);
                            });
                        } else if (response.status === "success") {
                            window.location.href = response.redirect;
                        }
                    },
                    error: function (xhr) {
                        console.log(xhr.responseText);
                    }
                });
            });
        });
    </script>

</body>

</html>