<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Add Membership Eligibility Details | Maalav Milk Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php include_once('common_page/links.php'); ?>
</head>

<body>
    <!-- Begin page -->
    <div class="wrapper">

        <?php include_once('common_page/sidebar.php'); ?>
        <?php include_once('common_page/header.php'); ?>

        <!-- ============================================================== -->
        <!-- Start Main Content -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="container-fluid">
                <div class="page-title-head d-flex align-items-center">
                    <div class="flex-grow-1">
                        <h4 class="fs-xl fw-bold m-0">Add Membership Eligibility Details</h4>
                    </div>


                </div>


                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header justify-content-between">
                                <h4 class="card-title">Add Membership Eligibility Details</h4>
                            </div>

                            <div class="card-body">
                                <form class="row g-3 needs-validation" id="detailsForm" method="POST"
                                    enctype="multipart/form-data" novalidate>

                                    <!-- Product Name -->

                                    <!-- ===== Section One ===== -->
                                    <div class="col-md-6">
                                        <label class="form-label">Title One</label>
                                        <input type="text" class="form-control" name="title_one" required>
                                        <span id="error-title_one" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Hindi Title One</label>
                                        <input type="text" class="form-control" name="hindi_title_one" required>
                                        <span id="error-hindi_title_one" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Content One</label>
                                        <div id="editor_one" style="height: 300px;"></div>
                                        <input type="hidden" name="content_one" id="hidden-content-one">
                                        <span id="error-content_one" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Hindi Content One</label>
                                        <div id="editor_four" style="height: 300px;"></div>
                                        <input type="hidden" name="hindi_content_one" id="hidden-hindi-content-one">
                                        <span id="error-hindi_content_one" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-12">
                                        <label class="form-label">Image One</label>
                                        <input type="file" id="featured_image_one" name="featured_image_one"
                                            class="filepond form-control" required>
                                        <span id="error-featured_image_one" class="text-danger error"></span>
                                    </div>

                                    <!-- ===== Section Two ===== -->
                                    <div class="col-md-6">
                                        <label class="form-label">Title Two</label>
                                        <input type="text" class="form-control" name="title_two" required>
                                        <span id="error-title_two" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Hindi Title Two</label>
                                        <input type="text" class="form-control" name="hindi_title_two" required>
                                        <span id="error-hindi_title_two" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Content Two</label>
                                        <div id="editor_two" style="height: 300px;"></div>
                                        <input type="hidden" name="content_two" id="hidden-content-two">
                                        <span id="error-content_two" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Hindi Content Two</label>
                                        <div id="editor_five" style="height: 300px;"></div>
                                        <input type="hidden" name="hindi_content_two" id="hidden-hindi-content-two">
                                        <span id="error-hindi_content_two" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-12">
                                        <label class="form-label">Image Two</label>
                                        <input type="file" id="featured_image_two" name="featured_image_two"
                                            class="filepond form-control" required>
                                        <span id="error-featured_image_two" class="text-danger error"></span>
                                    </div>

                                    <div class="col-md-12">
                                        <label class="form-label">Upload Pdf</label>
                                        <input type="file" id="pdf" name="pdf" class="filepond form-control"
                                            accept="application/pdf" required>
                                        <span id="error-pdf" class="text-danger error"></span>
                                    </div>



                                    <div class="col-12">
                                        <button class="btn btn-primary" type="submit">Submit Form</button>
                                    </div>
                                </form>

                            </div> <!-- end card-body-->
                        </div> <!-- end card-->
                    </div>
                </div>



            </div>
            <!-- container -->

            <?php include_once('common_page/footer.php'); ?>


        </div>

        <!-- ============================================================== -->
        <!-- End of Main Content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <?php include_once('common_page/script.php'); ?>


    <script>
        $(document).ready(function () {
            // Initialize Quill editors
            const quill1 = new Quill('#editor_one', { theme: 'snow' });
            const quill2 = new Quill('#editor_two', { theme: 'snow' });
            const quill4 = new Quill('#editor_four', { theme: 'snow' });
            const quill5 = new Quill('#editor_five', { theme: 'snow' });

            // Initialize FilePond instances
            const pond1 = FilePond.create(document.querySelector('#featured_image_one'));
            const pond2 = FilePond.create(document.querySelector('#featured_image_two'));
            const pond3 = FilePond.create(document.querySelector('#pdf'), {
                acceptedFileTypes: ['application/pdf'],
                labelFileTypeNotAllowed: 'Only PDF files are allowed.',
                fileValidateTypeDetectType: (source, type) => new Promise((resolve) => {
                    resolve(type);
                })
            });

            $("#detailsForm").on("submit", function (e) {
                e.preventDefault();
                $(".error").html("");

                // Set Quill content
                $("#hidden-content-one").val(quill1.root.innerHTML);
                $("#hidden-content-two").val(quill2.root.innerHTML);
                $("#hidden-hindi-content-one").val(quill4.root.innerHTML);
                $("#hidden-hindi-content-two").val(quill5.root.innerHTML);

                const formData = new FormData(this);

                // Add FilePond files
                if (pond1.getFiles().length > 0)
                    formData.append('featured_image_one', pond1.getFiles()[0].file);
                if (pond2.getFiles().length > 0)
                    formData.append('featured_image_two', pond2.getFiles()[0].file);
                if (pond3.getFiles().length > 0)
                    formData.append('pdf', pond3.getFiles()[0].file);


                $.ajax({
                    url: "<?= base_url('admin/membership_eligibility/submit_membership_eligibility') ?>",
                    type: "POST",
                    data: formData,
                    contentType: false,
                    processData: false,
                    dataType: "json",
                    success: function (response) {
                        if (response.status === "error") {
                            $.each(response.errors, function (key, val) {
                                $("#error-" + key).html(val);
                            });
                        } else if (response.status === "success") {
                            window.location.href = response.redirect;
                        }
                    },
                    error: function (xhr) {
                        console.error(xhr.responseText);
                    }
                });
            });
        });
    </script>




</body>

</html>