<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Add Page | Maalav Milk Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php include_once('common_page/links.php'); ?>
</head>

<body>
    <!-- Begin page -->
    <div class="wrapper">

        <?php include_once('common_page/sidebar.php'); ?>
        <?php include_once('common_page/header.php'); ?>

        <!-- ============================================================== -->
        <!-- Start Main Content -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="container-fluid">
                <div class="page-title-head d-flex align-items-center">
                    <div class="flex-grow-1">
                        <h4 class="fs-xl fw-bold m-0">Add Page</h4>
                    </div>


                </div>


                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header justify-content-between">
                                <h4 class="card-title">Add Page</h4>
                            </div>

                            <div class="card-body">
                                <form class="row g-3 needs-validation" id="blogForm" method="POST"
                                    enctype="multipart/form-data" novalidate>
                                    <div class="col-md-6">
                                        <label class="form-label">Page Name</label>
                                        <input type="text" class="form-control" name="page_name" required>
                                        <span id="error-page_name" class="text-danger error"></span>
                                    </div>

                                    <div class="col-md-6">
                                        <label class="form-label">Hindi Page Name</label>
                                        <input type="text" class="form-control" name="hindi_page_name" required>
                                        <span id="error-hindi_page_name" class="text-danger error"></span>
                                    </div>

                                    <div class="col-md-6">
                                        <label class="form-label">Slug</label>
                                        <input type="text" class="form-control" name="slug" required>
                                        <small>Only lowercase letters, numbers, and hyphens (-) allowed.</small>
                                        <span id="error-slug" class="text-danger error"></span>
                                    </div>

                                    <div class="col-md-12">
                                        <label class="form-label">Content</label>
                                        <textarea id="editorEnglish" name="content"></textarea>
                                        <span id="error-content" class="text-danger error"></span>
                                    </div>

                                    <div class="col-md-12">
                                        <label class="form-label">Hindi Content</label>
                                        <textarea id="editorHindi" name="hindi_content"></textarea>
                                        <span id="error-hindi_content" class="text-danger error"></span>
                                    </div>

                                    <div class="col-12">
                                        <button class="btn btn-primary" type="submit">Submit Form</button>
                                    </div>
                                </form>

                            </div> <!-- end card-body-->
                        </div> <!-- end card-->
                    </div>
                </div>



            </div>
            <!-- container -->

            <?php include_once('common_page/footer.php'); ?>


        </div>

        <!-- ============================================================== -->
        <!-- End of Main Content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <?php include_once('common_page/script.php'); ?>

    <script src="https://cdn.ckeditor.com/ckeditor5/39.0.1/classic/ckeditor.js"></script>
    <script>
        $(document).ready(function () {

            // ✅ Common CKEditor config with resize options
            const editorConfig = {
                ckfinder: {
                    uploadUrl: "<?= base_url('admin/create_page/upload_ck_image') ?>"
                },
                toolbar: [
                    'heading', '|', 'bold', 'italic', 'link', 'bulletedList', 'numberedList',
                    '|', 'insertTable', 'blockQuote', 'undo', 'redo',
                    '|', 'imageUpload', 'alignment', '|', 'resizeImage'
                ],
                image: {
                    resizeUnit: '%', // You can also use 'px'
                    resizeOptions: [
                        {
                            name: 'resizeImage:original',
                            label: 'Original size',
                            value: null
                        },
                        {
                            name: 'resizeImage:25',
                            label: '25%',
                            value: '25'
                        },
                        {
                            name: 'resizeImage:50',
                            label: '50%',
                            value: '50'
                        },
                        {
                            name: 'resizeImage:75',
                            label: '75%',
                            value: '75'
                        },
                        {
                            name: 'resizeImage:100',
                            label: '100%',
                            value: '100'
                        }
                    ],
                    toolbar: [
                        'imageStyle:inline',
                        'imageStyle:block',
                        'imageStyle:side',
                        '|', 'resizeImage', '|', 'linkImage'
                    ]
                }
            };

            // ✅ Initialize CKEditor for English
            ClassicEditor.create(document.querySelector('#editorEnglish'), editorConfig)
                .then(editor => window.editorEnglish = editor)
                .catch(error => console.error(error));

            // ✅ Initialize CKEditor for Hindi (with language option)
            const hindiConfig = { ...editorConfig, language: 'hi' };

            ClassicEditor.create(document.querySelector('#editorHindi'), hindiConfig)
                .then(editor => window.editorHindi = editor)
                .catch(error => console.error(error));

            // ✅ Submit form
            $("#blogForm").on("submit", function (e) {
                e.preventDefault();
                $(".error").html("");

                const formData = new FormData(this);
                formData.set('content', window.editorEnglish.getData());
                formData.set('hindi_content', window.editorHindi.getData());

                $.ajax({
                    url: "<?= base_url('admin/create_page/submit_page') ?>",
                    type: "POST",
                    data: formData,
                    contentType: false,
                    processData: false,
                    dataType: "json",
                    success: function (response) {
                        if (response.status === "error") {
                            $.each(response.errors, function (key, val) {
                                $("#error-" + key).html(val);
                            });
                        } else if (response.status === "success") {
                            window.location.href = response.redirect;
                        }
                    },
                    error: function (xhr) {
                        console.log("AJAX Error:", xhr.responseText);
                    }
                });
            });
        });
    </script>






</body>

</html>