<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Add Slider | Maalav Milk Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php include_once('common_page/links.php'); ?>
</head>

<body>
    <!-- Begin page -->
    <div class="wrapper">

        <?php include_once('common_page/sidebar.php'); ?>
        <?php include_once('common_page/header.php'); ?>

        <!-- ============================================================== -->
        <!-- Start Main Content -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="container-fluid">
                <div class="page-title-head d-flex align-items-center">
                    <div class="flex-grow-1">
                        <h4 class="fs-xl fw-bold m-0">Add Slider</h4>
                    </div>


                </div>


                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header justify-content-between">
                                <h4 class="card-title">Add Slider</h4>
                            </div>

                            <div class="card-body">
                                <form class="row g-3 needs-validation" novalidate id="sliderForm" method="POST"
                                    enctype="multipart/form-data">

                                    <div class="col-md-6">
                                        <label for="validationCustom01" class="form-label">Title</label>
                                        <input type="text" name="title" id="validationCustom01" class="form-control">
                                        <div class="valid-feedback">Looks great!</div>
                                        <div class="invalid-feedback">Please choose a category.</div>
                                        <span id="error-title" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="validationCustom02" class="form-label">Short Detail</label>
                                        <input type="text" name="detail" id="validationCustom02" class="form-control">
                                        <div class="valid-feedback">Looks great!</div>
                                        <div class="invalid-feedback">Please choose a category.</div>
                                        <span id="error-detail" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="validationCustom01" class="form-label">Hindi Title</label>
                                        <input type="text" name="hindi_title" id="validationCustom01"
                                            class="form-control">
                                        <div class="valid-feedback">Looks great!</div>
                                        <div class="invalid-feedback">Please choose a category.</div>
                                        <span id="error-title" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="validationCustom02" class="form-label">Hindi Short Detail</label>
                                        <input type="text" name="hindi_detail" id="validationCustom02"
                                            class="form-control">
                                        <div class="valid-feedback">Looks great!</div>
                                        <div class="invalid-feedback">Please choose a category.</div>
                                        <span id="error-detail" class="text-danger error"></span>
                                    </div>
                                    <div>
                                        <h5 class="mb-3">slider Images</h5>
                                        <div class="filepond-uploader three-grid">
                                            <input type="file" class="filepond filepond-input-multiple"
                                                name="slider_image[]" data-allow-reorder="true" data-max-file-size="3MB"
                                                data-max-files="1" required>
                                        </div>
                                        <span id="error-image" class="text-danger error"></span>
                                    </div>


                                    <div class="col-12">
                                        <button class="btn btn-primary" type="submit">Submit Form</button>
                                    </div>
                                </form>



                            </div> <!-- end card-body-->
                        </div> <!-- end card-->
                    </div>
                </div>



            </div>
            <!-- container -->

            <?php include_once('common_page/footer.php'); ?>


        </div>

        <!-- ============================================================== -->
        <!-- End of Main Content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <?php include_once('common_page/script.php'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // Initialize FilePond
            const pond = FilePond.create(document.querySelector('.filepond-input-multiple'), {
                allowMultiple: true,
                maxFiles: 1,
                maxFileSize: '50MB',
                server: null, // no instant upload
                instantUpload: false
            });

            $("#sliderForm").on("submit", function (e) {
                e.preventDefault();
                $(".error").html("");

                var formData = new FormData(this);

                // Append FilePond files with filename (important!)
                pond.getFiles().forEach((file) => {
                    formData.append('slider_image[]', file.file, file.file.name);
                });

                $.ajax({
                    url: "<?= base_url('admin/slider/submit_slider') ?>",
                    type: "POST",
                    data: formData,
                    contentType: false,
                    processData: false,
                    dataType: "json",
                    success: function (response) {
                        if (response.status === "error") {
                            $.each(response.errors, function (key, val) {
                                $("#error-" + key).html(val);
                            });
                        } else if (response.status === "success") {
                            window.location.href = response.redirect;
                        }
                    },
                    error: function (xhr) {
                        console.log(xhr.responseText);
                    }
                });
            });
        });
    </script>



</body>

</html>