<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Sign In | Maalav Milk Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php include_once('common_page/links.php') ?>
</head>

<body>

    <div class="auth-box overflow-hidden align-items-center d-flex">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xxl-4 col-md-6 col-sm-8">
                    <div class="card p-4">

                        <div class="auth-brand text-center mb-4">
                            <a href="" class="logo-dark">
                                <img src="<?= base_url() ?>assets/img/logo/Logo.png" alt="dark logo" height="80">
                            </a>
                            <a href="" class="logo-light">
                                <img src="<?= base_url() ?>assets/img/logo/Logo.png" alt="logo" height="80">
                            </a>
                            <p class="text-muted w-lg-75 mt-3 mx-auto">Let’s get you signed in. Enter your email and
                                password to continue.</p>
                        </div>
                        <?php $error_email = form_error('email'); ?>
                        <?php $error_password = form_error('password'); ?>

                        <form action="<?= base_url('admin/login/admin_login') ?>" method="POST">
                            <div class="mb-3">
                                <label for="userEmail" class="form-label">Email address</label>
                                <input type="email" class="form-control <?= $error_email ? 'is-invalid' : '' ?>"
                                    id="userEmail" name="email" value="<?= set_value('email') ?>" required>
                                <?php if ($error_email): ?>
                                    <div class="invalid-feedback"><?= $error_email ?></div>
                                <?php endif; ?>
                            </div>

                            <div class="mb-3">
                                <label for="userPassword" class="form-label">Password</label>
                                <div class="input-group">
                                    <input type="password"
                                        class="form-control <?= $error_password ? 'is-invalid' : '' ?>"
                                        id="userPassword" name="password" required>
                                    <button type="button" class="btn btn-outline-secondary"
                                        id="togglePassword">Show</button>
                                </div>
                                <?php if ($error_password): ?>
                                    <div class="invalid-feedback d-block"><?= $error_password ?></div>
                                <?php endif; ?>
                            </div>

                            <div class="mb-3 form-check">
                                <input type="checkbox" class="form-check-input" name="remember" id="rememberMe">
                                <label class="form-check-label" for="rememberMe">Keep me signed in</label>
                            </div>

                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary fw-semibold py-2">Sign In</button>
                            </div>
                        </form>








                        <p class="text-muted text-center mt-4 mb-0">
                            New here? <a href="<?= base_url('register') ?>"
                                class="text-decoration-underline link-offset-3 fw-semibold">Create an account</a>
                        </p>
                    </div>

                    <p class="text-center text-muted mt-4 mb-0">
                        ©
                        <script>document.write(new Date().getFullYear())</script> Maalav Milk,
                        <span class="fw-semibold">Developed by <a href="http://namami.co.in/" target="blank">Namami
                                Software</a></span>

                    </p>
                </div>
            </div>
        </div>
    </div>


    <script>
        const togglePassword = document.getElementById('togglePassword');
        const passwordField = document.getElementById('userPassword');

        togglePassword.addEventListener('click', function () {
            const type = passwordField.getAttribute('type') === 'password' ? 'text' : 'password';
            passwordField.setAttribute('type', type);
            this.textContent = type === 'password' ? 'Show' : 'Hide';
        });
    </script>

</body>

</html>