<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Edit Annual Report | Maalav Milk Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php include_once('common_page/links.php'); ?>
</head>

<body>
    <!-- Begin page -->
    <div class="wrapper">

        <?php include_once('common_page/sidebar.php'); ?>
        <?php include_once('common_page/header.php'); ?>

        <!-- ============================================================== -->
        <!-- Start Main Content -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="container-fluid">
                <div class="page-title-head d-flex align-items-center">
                    <div class="flex-grow-1">
                        <h4 class="fs-xl fw-bold m-0">Edit Annual Report</h4>
                    </div>


                </div>


                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header justify-content-between">
                                <h4 class="card-title">Edit Annual Report</h4>
                            </div>

                            <div class="card-body">
                                <form class="row g-3 needs-validation" id="reportForm" method="POST"
                                    enctype="multipart/form-data" novalidate>
                                    <input type="hidden" name="id" value="<?= $report->id ?>">

                                    <div class="col-md-6">
                                        <label for="validationCustom01" class="form-label">Subject</label>
                                        <input type="text" class="form-control" id="validationCustom01" name="subject"
                                            value="<?= $report->subject ?>" required>
                                        <div class="valid-feedback"> Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Title.</div>
                                        <span id="error-subject" class="text-danger error"></span>
                                    </div>

                                    <div class="col-md-6">
                                        <label for="validationCustom02" class="form-label">Hindi Subject</label>
                                        <input type="text" class="form-control" id="validationCustom02"
                                            name="hindi_subject" value="<?= $report->hindi_subject ?>" required>
                                        <div class="valid-feedback"> Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Title.</div>
                                        <span id="error-hindi_subject" class="text-danger error"></span>
                                    </div>



                                    <div class="col-md-12">
                                        <label for="featured_file" class="form-label">File (PDF or image)</label>
                                        <div class="filepond-uploader">
                                            <!-- note: accept is optional but gives client-side hint -->
                                            <input type="file" id="featured_file" name="featured_file"
                                                class="filepond filepond-input-multiple form-control"
                                                accept=".pdf,image/*" data-allow-reorder="true" data-max-file-size="5MB"
                                                data-max-files="1" aria-label="file example">
                                        </div>

                                        <div class="valid-feedback">Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid file.</div>
                                        <span id="error-featured_file" class="text-danger error"></span>
                                    </div>

                                    <div class="col-12">
                                        <button class="btn btn-primary" type="submit">Submit Form</button>
                                    </div>
                                </form>


                            </div> <!-- end card-body-->
                        </div> <!-- end card-->
                    </div>
                </div>



            </div>
            <!-- container -->

            <?php include_once('common_page/footer.php'); ?>


        </div>

        <!-- ============================================================== -->
        <!-- End of Main Content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <?php include_once('common_page/script.php'); ?>


    <script>
        $(document).ready(function () {
            // Fetch existing file path from server-side variable (should be relative path like 'uploads/tender/abc.pdf' or full URL)
            let featuredImage = '<?= $report->featured_file ?>';

            // Normalize to full URL if needed
            if (featuredImage && !featuredImage.startsWith('http')) {
                featuredImage = '<?= base_url() ?>' + featuredImage;
            }
            // Remove duplicate slashes (keep protocol)
            featuredImage = featuredImage ? featuredImage.replace(/([^:]\/)\/+/g, "$1") : '';

            // Init FilePond
            FilePond.registerPlugin(); // register any FilePond plugins you use earlier in your page

            const pond = FilePond.create(document.querySelector('#featured_file'), {
                allowMultiple: false,
                maxFiles: 1,
                files: featuredImage ? [{
                    source: featuredImage,
                    options: { type: 'local' } // local file preview, not a newly uploaded file
                }] : []
            });

            // Submit handler
            $("#reportForm").on("submit", function (e) {
                e.preventDefault();
                $(".error").html("");

                const formEl = this;
                const formData = new FormData(formEl);

                // If user uploaded a NEW file (not just preloaded local), append it
                const pondFiles = pond.getFiles();
                if (pondFiles.length > 0) {
                    // pondFiles[0].origin === 'local' means it is the preloaded file — no need to append
                    if (pondFiles[0].file && pondFiles[0].origin !== 'local') {
                        formData.append('featured_file', pondFiles[0].file);
                    }
                }

                $.ajax({
                    url: "<?= base_url('admin/annual_reports/update_report') ?>",
                    type: "POST",
                    data: formData,
                    contentType: false,
                    processData: false,
                    dataType: "json",
                    beforeSend: function () {
                        $("button[type=submit]").prop("disabled", true).text("Please wait...");
                    },
                    success: function (response) {
                        $("button[type=submit]").prop("disabled", false).text("Submit Form");

                        if (response.status === "error") {
                            // Show server validation errors
                            $.each(response.errors, function (key, val) {
                                $("#error-" + key).html(val);
                            });
                        } else if (response.status === "success") {
                            // redirect (server provides URL)
                            window.location.href = response.redirect;
                        } else {
                            console.error("Unexpected response:", response);
                        }
                    },
                    error: function (xhr) {
                        $("button[type=submit]").prop("disabled", false).text("Submit Form");
                        console.error("AJAX Error:", xhr.responseText);
                        // Optionally show a generic error
                        $("#error-featured_file").html("An unexpected error occurred. Check console.");
                    }
                });
            });
        });
    </script>





</body>

</html>