<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Edit Service Details | Maalav Milk Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php include_once('common_page/links.php'); ?>
</head>

<body>
    <!-- Begin page -->
    <div class="wrapper">

        <?php include_once('common_page/sidebar.php'); ?>
        <?php include_once('common_page/header.php'); ?>

        <!-- ============================================================== -->
        <!-- Start Main Content -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="container-fluid">
                <div class="page-title-head d-flex align-items-center">
                    <div class="flex-grow-1">
                        <h4 class="fs-xl fw-bold m-0">Edit Service Details</h4>
                    </div>


                </div>


                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header justify-content-between">
                                <h4 class="card-title">Edit Service Details</h4>
                            </div>

                            <div class="card-body">
                                <form class="row g-3 needs-validation" id="detailsForm" method="POST"
                                    enctype="multipart/form-data" novalidate>

                                    <input type="hidden" name="id" value="<?= $award->id ?>">

                                    <!-- service Name -->
                                    <div class="col-md-6">
                                        <label class="form-label">Title</label>
                                        <input type="text" class="form-control" name="title"
                                            value="<?= $award->title ?>" required>
                                        <span id="error-title" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Hindi Title</label>
                                        <input type="text" class="form-control" name="hindi_title"
                                            value="<?= $award->hindi_title ?>" required>
                                        <span id="error-hindi_title" class="text-danger error"></span>
                                    </div>

                                    <div class="col-md-12">
                                        <label class="form-label">Image One</label>
                                        <input type="file" id="featured_image_one" name="featured_image_one"
                                            class="filepond form-control" required>
                                        <span id="error-featured_image_one" class="text-danger error"></span>
                                    </div>

                                    <div class="col-md-12">
                                        <label class="form-label">Image Two</label>
                                        <input type="file" id="featured_image_two" name="featured_image_two"
                                            class="filepond form-control" required>
                                        <span id="error-featured_image_two" class="text-danger error"></span>
                                    </div>


                                    <div class="col-12">
                                        <button class="btn btn-primary" type="submit">Submit Form</button>
                                    </div>
                                </form>

                            </div> <!-- end card-body-->
                        </div> <!-- end card-->
                    </div>
                </div>



            </div>
            <!-- container -->

            <?php include_once('common_page/footer.php'); ?>


        </div>

        <!-- ============================================================== -->
        <!-- End of Main Content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <?php include_once('common_page/script.php'); ?>


    <script>
        $(document).ready(function () {



            // Base URL for images
            const baseUrl = "<?= base_url() ?>";

            // Helper function to clean and build URLs
            function formatImageUrl(imgPath) {
                if (!imgPath) return null;
                if (!imgPath.startsWith("http")) imgPath = baseUrl + imgPath;
                return imgPath.replace(/([^:]\/)\/+/g, "$1");
            }

            // Existing images
            const img1 = formatImageUrl("<?= base_url($award->featured_image_one) ?>");
            const img2 = formatImageUrl("<?= base_url($award->featured_image_two) ?>");

            // Initialize FilePond with existing previews
            const pond1 = FilePond.create(document.querySelector('#featured_image_one'), {
                allowMultiple: false,
                maxFiles: 1,
                files: img1 ? [{ source: img1, options: { type: 'local' } }] : []
            });

            const pond2 = FilePond.create(document.querySelector('#featured_image_two'), {
                allowMultiple: false,
                maxFiles: 1,
                files: img2 ? [{ source: img2, options: { type: 'local' } }] : []
            });



            // Form submit
            $("#detailsForm").on("submit", function (e) {
                e.preventDefault();
                $(".error").html("");


                const formData = new FormData(this);

                // Append FilePond files (only if new files uploaded)
                if (pond1.getFiles().length > 0 && pond1.getFiles()[0].file)
                    formData.append('featured_image_one', pond1.getFiles()[0].file);
                if (pond2.getFiles().length > 0 && pond2.getFiles()[0].file)
                    formData.append('featured_image_two', pond2.getFiles()[0].file);


                $.ajax({
                    url: "<?= base_url('admin/award_and_recognition/update_award') ?>",
                    type: "POST",
                    data: formData,
                    contentType: false,
                    processData: false,
                    dataType: "json",
                    success: function (response) {
                        if (response.status === "error") {
                            $.each(response.errors, function (key, val) {
                                $("#error-" + key).html(val);
                            });
                        } else if (response.status === "success") {
                            window.location.href = response.redirect;
                        }
                    },
                    error: function (xhr) {
                        console.error(xhr.responseText);
                    }
                });
            });
        });
    </script>





</body>

</html>