<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Edit Chairman Note Details | Maalav Milk Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php include_once('common_page/links.php'); ?>
</head>

<body>
    <!-- Begin page -->
    <div class="wrapper">

        <?php include_once('common_page/sidebar.php'); ?>
        <?php include_once('common_page/header.php'); ?>

        <!-- ============================================================== -->
        <!-- Start Main Content -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="container-fluid">
                <div class="page-title-head d-flex align-items-center">
                    <div class="flex-grow-1">
                        <h4 class="fs-xl fw-bold m-0">Edit Chairman Note Details</h4>
                    </div>


                </div>


                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header justify-content-between">
                                <h4 class="card-title">Edit Chairman Note Details</h4>
                            </div>

                            <div class="card-body">
                                <form class="row g-3 needs-validation" id="detailsForm" method="POST"
                                    enctype="multipart/form-data" novalidate>


                                    <input type="hidden" name="id" value="<?= $details->id ?>">
                                    <!-- ===== Section One ===== -->

                                    <div class="col-md-6">
                                        <label class="form-label">Content</label>
                                        <div id="editor_one" style="height: 300px;"></div>
                                        <input type="hidden" name="content" id="hidden-content-one">
                                        <span id="error-content_one" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Hindi Content</label>
                                        <div id="editor_four" style="height: 300px;"></div>
                                        <input type="hidden" name="hindi_content" id="hidden-hindi-content-one">
                                        <span id="error-hindi_content_one" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-12">
                                        <label class="form-label">Image One</label>
                                        <input type="file" id="featured_image" name="featured_image"
                                            class="filepond form-control" required>
                                        <span id="error-featured_image" class="text-danger error"></span>
                                    </div>

                                    <!-- ===== Section Three ===== -->


                                    <div class="col-12">
                                        <button class="btn btn-primary" type="submit">Submit Form</button>
                                    </div>
                                </form>

                            </div> <!-- end card-body-->
                        </div> <!-- end card-->
                    </div>
                </div>



            </div>
            <!-- container -->

            <?php include_once('common_page/footer.php'); ?>


        </div>

        <!-- ============================================================== -->
        <!-- End of Main Content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <?php include_once('common_page/script.php'); ?>


    <script>
        $(document).ready(function () {

            const quill1 = new Quill('#editor_one', { theme: 'snow' });
            const quill4 = new Quill('#editor_four', { theme: 'snow' });

            quill1.root.innerHTML = `<?= addslashes($details->content) ?>`;
            quill4.root.innerHTML = `<?= addslashes($details->hindi_content) ?>`;

            let imgOne = `<?= base_url($details->featured_image) ?>`;
            imgOne = imgOne.replace(/([^:]\/)\/+/g, "$1");

            const pond1 = FilePond.create(document.querySelector('#featured_image'), {
                allowMultiple: false,
                maxFiles: 1,
                files: imgOne ? [{
                    source: imgOne,
                    options: { type: 'local' }
                }] : []
            });


            $("#detailsForm").on("submit", function (e) {
                e.preventDefault();
                $(".error").html("");

                $("#hidden-content-one").val(quill1.root.innerHTML);
                $("#hidden-hindi-content-one").val(quill4.root.innerHTML);

                let formData = new FormData(this);

                if (pond1.getFiles().length > 0) {
                    formData.append('featured_image', pond1.getFiles()[0].file);
                }

                $.ajax({
                    url: "<?= base_url('admin/about/update_chairman_note') ?>",
                    type: "POST",
                    data: formData,
                    contentType: false,
                    processData: false,
                    dataType: "json",

                    success: function (response) {

                        if (response.status === "error") {
                            $.each(response.errors, function (key, val) {
                                $("#error-" + key).html(val);
                            });
                        }

                        if (response.status === "success") {
                            window.location.href = response.redirect;
                        }
                    },
                    error: function (xhr) {
                        console.log(xhr.responseText);
                    }
                });

            });

        });

    </script>




</body>

</html>