<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Edit Page | Maalav Milk Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php include_once('common_page/links.php'); ?>
</head>

<body>
    <!-- Begin page -->
    <div class="wrapper">

        <?php include_once('common_page/sidebar.php'); ?>
        <?php include_once('common_page/header.php'); ?>

        <!-- ============================================================== -->
        <!-- Start Main Content -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="container-fluid">
                <div class="page-title-head d-flex align-items-center">
                    <div class="flex-grow-1">
                        <h4 class="fs-xl fw-bold m-0">Edit Page</h4>
                    </div>


                </div>


                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header justify-content-between">
                                <h4 class="card-title">Edit Page</h4>
                            </div>

                            <div class="card-body">
                                <form class="row g-3 needs-validation" id="detailsForm" method="POST"
                                    enctype="multipart/form-data" novalidate>

                                    <input type="hidden" name="id" value="<?= $data->id ?>">

                                    <!-- service Name -->


                                    <!-- ===== Section One ===== -->
                                    <div class="col-md-6">
                                        <label class="form-label">Page Name</label>
                                        <input type="text" class="form-control" name="page_name"
                                            value="<?= $data->page_name ?>" required>
                                        <span id="error-page_name" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Hindi Page Name</label>
                                        <input type="text" class="form-control" name="hindi_page_name"
                                            value="<?= $data->hindi_page_name ?>" required>
                                        <span id="error-hindi_page_name" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Content</label>
                                        <div id="editor_one" style="height: 300px;"></div>
                                        <input type="hidden" name="content" id="hidden-content-one">
                                        <span id="error-content" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Hindi Content</label>
                                        <div id="editor_four" style="height: 300px;"></div>
                                        <input type="hidden" name="hindi_content" id="hidden-hindi-content-one">
                                        <span id="error-hindi_content" class="text-danger error"></span>
                                    </div>


                                    <div class="col-12">
                                        <button class="btn btn-primary" type="submit">Submit Form</button>
                                    </div>
                                </form>

                            </div> <!-- end card-body-->
                        </div> <!-- end card-->
                    </div>
                </div>



            </div>
            <!-- container -->

            <?php include_once('common_page/footer.php'); ?>


        </div>

        <!-- ============================================================== -->
        <!-- End of Main Content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <?php include_once('common_page/script.php'); ?>


    <script>
        $(document).ready(function () {

            // Initialize Quill editors
            const quill1 = new Quill('#editor_one', { theme: 'snow' });
            const quill2 = new Quill('#editor_two', { theme: 'snow' });


            // Load existing content into editors
            quill1.root.innerHTML = `<?= addslashes($details->content) ?>`;
            quill2.root.innerHTML = `<?= addslashes($details->hindi_content) ?>`;



            // Form submit
            $("#detailsForm").on("submit", function (e) {
                e.preventDefault();
                $(".error").html("");

                // Set hidden content for Quill editors
                $("#hidden-content-one").val(quill1.root.innerHTML);
                $("#hidden-content-two").val(quill2.root.innerHTML);

                const formData = new FormData(this);


                $.ajax({
                    url: "<?= base_url('admin/service/update_service_details') ?>",
                    type: "POST",
                    data: formData,
                    contentType: false,
                    processData: false,
                    dataType: "json",
                    success: function (response) {
                        if (response.status === "error") {
                            $.each(response.errors, function (key, val) {
                                $("#error-" + key).html(val);
                            });
                        } else if (response.status === "success") {
                            window.location.href = response.redirect;
                        }
                    },
                    error: function (xhr) {
                        console.error(xhr.responseText);
                    }
                });
            });
        });
    </script>





</body>

</html>