<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Gallery | Maalav Milk Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php include_once('common_page/links.php'); ?>
</head>

<body>
    <!-- Begin page -->
    <div class="wrapper">

        <?php include_once('common_page/sidebar.php'); ?>
        <?php include_once('common_page/header.php'); ?>

        <!-- ============================================================== -->
        <!-- Start Main Content -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="container-fluid">
                <div class="page-title-head d-flex align-items-center">
                    <div class="flex-grow-1">
                        <h4 class="fs-xl fw-bold m-0">Gallery</h4>
                    </div>

                    <div class="text-end">
                        <a href="<?= base_url('add-gallery') ?>" class="btn btn-soft-secondary">
                            Add Gallery &nbsp;
                            <i class="fa-solid fa-arrow-right"></i>
                        </a>
                    </div>
                </div>


                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header justify-content-between">
                                <h4 class="card-title"> Gallery DataTable </h4>
                            </div>
                            <div class="card-body">
                                <table data-tables="basic" class="table table-striped dt-responsive align-middle mb-0">
                                    <thead class="thead-sm text-uppercase fs-xxs">
                                        <tr>
                                            <th>s. No.</th>
                                            <th>Year</th>
                                            <th>Image</th>
                                            <th>Gallery category</th>
                                            <th>Hindi Gallery Category</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $i = 1;
                                        foreach ($gallery as $data): ?>
                                            <tr>
                                                <td><?= $i++ ?></td>
                                                <td><?= $data->year ?></td>
                                                <td><img src="<?= base_url($data->gallery_image) ?>" alt="gallery image"
                                                        width="50"></td>
                                                <td><?= $data->gallery_category ?></td>
                                                <td><?= $data->hindi_gallery_category ?></td>
                                                <td><?= $data->status ?></td>
                                                <td>
                                                    <div class="d-flex gap-1">
<a href="<?= base_url('admin/gallery/edit_gallery/' . $data->id) ?>"
                                                            class="btn btn-light btn-icon btn-sm rounded-circle"><i
                                                                class="ti ti-edit fs-lg"></i></a>

                                                        <a href="<?= base_url('admin/gallery/delete_gallery/' . $data->id) ?>"
                                                            data-table-delete-row
                                                            class="btn btn-danger btn-icon btn-sm rounded-circle"><i
                                                                class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div> <!-- end card-body-->
                        </div> <!-- end card-->
                    </div>
                </div>



            </div>
            <!-- container -->

            <?php if ($this->session->flashdata('message')): ?>
                <div class="toast-container position-fixed top-0 end-0 p-3" style="z-index: 9999">
                    <div id="flashToast" class="toast align-items-center text-bg-success border-0 shadow-lg mt-3"
                        role="alert" aria-live="assertive" aria-atomic="true">
                        <div class="d-flex">
                            <div class="toast-body fw-semibold">
                                <?= $this->session->flashdata('message'); ?>
                            </div>
                            <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"
                                aria-label="Close"></button>
                        </div>
                    </div>
                </div>

                <script>
                    document.addEventListener("DOMContentLoaded", function () {
                        var toastEl = document.getElementById('flashToast');
                        var toast = new bootstrap.Toast(toastEl, { delay: 3000 });
                        toast.show();
                    });
                </script>
            <?php endif; ?>

            <?php include_once('common_page/footer.php'); ?>


        </div>

        <!-- ============================================================== -->
        <!-- End of Main Content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <?php include_once('common_page/script.php'); ?>


</body>

</html>