<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>News & Event | Maalav Milk Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php include_once('common_page/links.php'); ?>
</head>

<body>
    <!-- Begin page -->
    <div class="wrapper">

        <?php include_once('common_page/sidebar.php'); ?>
        <?php include_once('common_page/header.php'); ?>

        <!-- ============================================================== -->
        <!-- Start Main Content -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="container-fluid">
                <div class="page-title-head d-flex align-items-center">
                    <div class="flex-grow-1">
                        <h4 class="fs-xl fw-bold m-0">News & Event</h4>
                    </div>

                    <div class="text-end d-flex gap-3">
                        <div class="status-button-container" data-section="news-and-event">
                            <button class="btn btn-secondary" disabled>
                                Loading...
                            </button>
                        </div>
                        <a href="<?= base_url('add-news-and-event') ?>" class="btn btn-soft-secondary">
                            Add News & Event &nbsp;
                            <i class="fa-solid fa-arrow-right"></i>
                        </a>
                    </div>
                </div>


                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header justify-content-between">
                                <h4 class="card-title"> News & Event DataTable </h4>
                            </div>
                            <div class="card-body">
                                <table data-tables="basic" class="table table-striped dt-responsive align-middle mb-0">
                                    <thead class="thead-sm text-uppercase fs-xxs">
                                        <tr>
                                            <th>S No.</th>
                                            <th>Image</th>
                                            <th>Title</th>
                                            <th>Hindi Title</th>
                                            <th>Category</th>
                                            <th>Hindi Category</th>
                                            <th>Content</th>
                                            <th>Hindi Content</th>
                                            <th>Status</th>
                                            <th>action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $i = 1;
                                        foreach ($news as $data): ?>
                                            <tr>
                                                <td><?= $i++ ?></td>
                                                <td>
                                                    <img src="<?= base_url($data->featured_image) ?>" alt="blog image"
                                                        width="50">
                                                </td>
                                                <td><?= word_limiter(strip_tags($data->title), 5) ?></td>
                                                <td><?= word_limiter(strip_tags($data->hindi_title), 5) ?></td>
                                                <td><?= $data->category ?></td>
                                                <td><?= $data->hindi_category ?></td>
                                                <td><?= word_limiter(strip_tags($data->content), 8) ?></td>
                                                <td><?= word_limiter(strip_tags($data->hindi_content), 8) ?></td>
                                                <td><?= $data->status ?></td>
                                                <td>
                                                    <div class="d-flex gap-1">
                                                        <?php if ($data->status == 'active'): ?>
                                                            <a href="<?= base_url('admin/news/set_status/' . $data->id) ?>"
                                                                class="btn btn-light btn-icon btn-sm rounded-circle"><i
                                                                    class="ti ti-eye fs-lg"></i></a>
                                                        <?php else: ?>
                                                            <a href="<?= base_url('admin/news/set_status/' . $data->id) ?>"
                                                                class="btn btn-danger btn-icon btn-sm rounded-circle"><i
                                                                    class="ti ti-eye-off fs-lg"></i></a>
                                                        <?php endif; ?>
                                                        <a href="<?= base_url('admin/news/edit_news/' . $data->id) ?>"
                                                            class="btn btn-light btn-icon btn-sm rounded-circle"><i
                                                                class="ti ti-edit fs-lg"></i></a>
                                                        <a href="<?= base_url('admin/news/delete_news/' . $data->id) ?>"
                                                            data-table-delete-row
                                                            class="btn btn-danger btn-icon btn-sm rounded-circle"><i
                                                                class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div> <!-- end card-body-->
                        </div> <!-- end card-->
                    </div>
                </div>



            </div>
            <!-- container -->

            <?php if ($this->session->flashdata('message')): ?>
                <div class="toast-container position-fixed top-0 end-0 p-3" style="z-index: 9999">
                    <div id="flashToast" class="toast align-items-center text-bg-success border-0 shadow-lg mt-3"
                        role="alert" aria-live="assertive" aria-atomic="true">
                        <div class="d-flex">
                            <div class="toast-body fw-semibold">
                                <?= $this->session->flashdata('message'); ?>
                            </div>
                            <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"
                                aria-label="Close"></button>
                        </div>
                    </div>
                </div>

                <script>
                    document.addEventListener("DOMContentLoaded", function () {
                        var toastEl = document.getElementById('flashToast');
                        var toast = new bootstrap.Toast(toastEl, { delay: 3000 });
                        toast.show();
                    });
                </script>
            <?php endif; ?>


            <?php include_once('common_page/footer.php'); ?>


        </div>

        <!-- ============================================================== -->
        <!-- End of Main Content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <?php include_once('common_page/script.php'); ?>

    <script>
        $(document).ready(function () {

            var container = $('.status-button-container');
            var sectionName = container.data('section');

            // Page load hone par status check karein
            checkStatus(sectionName);

            // Function: Database se status check karke button show karna
            function checkStatus(section_name) {
                $.ajax({
                    url: '<?php echo base_url("admin/section/check_status"); ?>',
                    type: 'POST',
                    data: {
                        section_name: section_name,
                        '<?php echo $this->security->get_csrf_token_name(); ?>': '<?php echo $this->security->get_csrf_hash(); ?>'
                    },
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            var buttonHtml = '';

                            // Current status ke opposite button dikhayen
                            if (response.status == 'active') {
                                // Active hai toh Inactive button dikhayen
                                buttonHtml = '<a href="javascript:void(0)" class="btn btn-danger status-toggle" data-current="active" data-section="' + section_name + '">Inactive</a>';
                            } else if (response.status == 'inactive') {
                                // Inactive hai toh Active button dikhayen
                                buttonHtml = '<a href="javascript:void(0)" class="btn btn-success status-toggle" data-current="inactive" data-section="' + section_name + '">Active</a>';
                            } else {
                                buttonHtml = '<span class="text-warning">Unknown Status</span>';
                            }

                            container.html(buttonHtml);

                        } else {
                            container.html('<span class="text-danger">Error: ' + response.message + '</span>');
                        }
                    },
                    error: function () {
                        container.html('<span class="text-danger">Error loading status</span>');
                    }
                });
            }

            // Status toggle button click event (dynamically created button ke liye)
            $(document).on('click', '.status-toggle', function () {
                var button = $(this);
                var currentStatus = button.data('current'); // 'active' or 'inactive'
                var section_name = button.data('section');

                // New status determine karein (opposite of current)
                var newStatus = currentStatus == 'active' ? 'inactive' : 'active';

                // Button disable karein
                button.prop('disabled', true);
                button.html('<i class="fa fa-spinner fa-spin"></i> Updating...');

                // Ajax request se status update karein
                $.ajax({
                    url: '<?php echo base_url("admin/section/update_status"); ?>',
                    type: 'POST',
                    data: {
                        section_name: section_name,
                        status: newStatus,
                        '<?php echo $this->security->get_csrf_token_name(); ?>': '<?php echo $this->security->get_csrf_hash(); ?>'
                    },
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            // Button update karein - opposite button dikhayen
                            if (newStatus == 'active') {
                                // Ab active ho gaya, toh Inactive button dikhayen
                                button.removeClass('btn-success').addClass('btn-danger');
                                button.text('Inactive');
                                button.data('current', 'active');
                            } else {
                                // Ab inactive ho gaya, toh Active button dikhayen
                                button.removeClass('btn-danger').addClass('btn-success');
                                button.text('Active');
                                button.data('current', 'inactive');
                            }

                            // Success message
                            alert('Status successfully updated to ' + newStatus + '!');
                        } else {
                            alert('Error: ' + response.message);
                            // Error hone par fresh status load karein
                            checkStatus(section_name);
                        }
                    },
                    error: function (xhr, status, error) {
                        alert('Ajax error: ' + error);
                        // Error hone par fresh status load karein
                        checkStatus(section_name);
                    },
                    complete: function () {
                        button.prop('disabled', false);
                    }
                });
            });

        });
    </script>
</body>

</html>