<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Job Applications | Maalav Milk Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php include_once('common_page/links.php'); ?>
    <style>
        .resume-viewer {
            height: 90vh;
            border: 1px solid #ddd;
            border-radius: 8px;
        }

        .info-card {
            background: #fff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        .info-card h5 {
            border-bottom: 2px solid #01AEEE;
            display: inline-block;
            padding-bottom: 5px;
        }
    </style>
</head>


<body>
    <!-- Begin page -->
    <div class="wrapper">

        <?php include_once('common_page/sidebar.php'); ?>
        <?php include_once('common_page/header.php'); ?>
        <div class="content-page">
            <div class="container py-4">
                <div class="row g-4">

                    <!-- LEFT: Applicant Details -->
                    <div class="col-md-5">
                        <div class="info-card p-4">
                            <h5>Applicant Information</h5>
                            <hr>
                            <p><strong>Position:</strong> <?= $application->position_name ?></p>
                            <p><strong>Name:</strong> <?= $application->name ?></p>
                            <p><strong>Email:</strong> <a
                                    href="mailto:<?= $application->email ?>"><?= $application->email ?></a></p>
                            <p><strong>Phone:</strong> <a href="tel:<?= $application->phone ?>"><?= $application->phone ?></a></p>
                            <p><strong>Location:</strong> <?= $application->job_location ?></p>
                            <p><strong>Additional Info:</strong><br><?= nl2br($application->info) ?></p>

                            <a href="<?= base_url($application->resume) ?>" target="_blank"
                                class="btn btn-primary w-100 mt-3">
                                <i class="bi bi-download"></i> Download Resume
                            </a>
                        </div>
                    </div>

                    <!-- RIGHT: Resume Preview -->
                    <div class="col-md-7">
                        <div class="resume-viewer bg-white p-2">
    <?php
    $ext = strtolower(pathinfo($application->resume, PATHINFO_EXTENSION));
    $file_url = base_url($application->resume);

    if ($ext === 'pdf') { ?>
        <!-- PDF Viewer -->
        <iframe src="<?= $file_url ?>" width="100%" height="100%"></iframe>

    <?php } elseif (in_array($ext, ['doc', 'docx'])) { ?>
        <!-- DOC/DOCX Viewer using Microsoft Office Embed -->
        <iframe src="https://view.officeapps.live.com/op/embed.aspx?src=<?= urlencode($file_url) ?>" width="100%" height="100%"></iframe>

    <?php } else { ?>
        <!-- Fallback for unsupported file types -->
        <div class="text-center mt-5">
            <p>📄 Cannot preview this file type.</p>
            <a href="<?= $file_url ?>" target="_blank" class="btn btn-primary">
                <i class="bi bi-download"></i> View / Download Resume
            </a>
        </div>
    <?php } ?>
</div>
                    </div>

                </div>
            </div>
        </div>

    </div>
    <!-- END wrapper -->

    <?php include_once('common_page/script.php'); ?>

</body>

</html>