<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="keywords" content="Maalav Milk - Maalav Milk home page" />
    <meta name="description" content="Maalav Milk - Maalav Milk home page" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

    <title><?= $language == 'hi' ? 'वार्षिक रिपोर्ट | मालव दूध' : 'Annual Reports | Maalav Milk' ?></title>
    <?php include_once('common_page/links.php'); ?>
</head>

<body>


    <div id="main-wrapper">
        <?php include_once('common_page/header.php'); ?>
        <main class="mb-5">
            <!-- Breadcum Start -->
            <section class="breadcum v1 bg-cover-center" data-background="assets/img/breadcum/bg.jpg">
                <div class="container">
                    <h2><?= $language == 'hi' ? 'वार्षिक रिपोर्ट' : 'Annual Reports' ?></h2>
                    <ul>
                        <li><a href="<?= base_url() ?>"><?= $language == 'hi' ? 'होम' : 'Home' ?></a></li>
                        <li><?= $language == 'hi' ? 'वार्षिक रिपोर्ट' : 'Annual Reports' ?></li>
                    </ul>
                </div>
            </section>
            <!-- Breadcum End -->
            <!-- Send Message Start -->
            <section class="send-message v1 mb-5">
               <div class="container my-5">
                    <div class="row g-4">

                        <!-- Example Item (repeat inside foreach loop) -->
                        <?php foreach ($report as $data) { ?>
                            <div class="col-md-4">
                                <a href="<?= $data->featured_file ?>" class="text-decoration-none">
                                    <div class="d-flex align-items-center p-3 bg-light border rounded shadow-sm">

                                        <!-- PDF Icon -->
                                        <div class="me-3">
                                            <img src="<?= base_url('assets/img/pdf.png') ?>" width="60" alt="PDF">
                                        </div>

                                        <!-- Title -->
                                        <div>
                                            <h6 class="mb-0 text-primary">
                                                <?= $language == 'hi' ? $data->hindi_subject : $data->subject ?>
                                            </h6>
                                        </div>

                                    </div>
                                </a>
                            </div>
                        <?php } ?>

                    </div>
                </div>
            </section>
            <!-- Send Message End -->

        </main>

        <?php include_once('common_page/footer.php'); ?>
    </div>
    <?php include_once('common_page/script.php'); ?>
</body>

</html>