<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="keywords" content="Maalav Milk - Maalav Milk home page" />
    <meta name="description" content="Maalav Milk - Maalav Milk home page" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

    <title>
        <?= $language == 'hi' ? 'करियर | मालव दूध' : 'Career | Maalav Milk' ?>
    </title>
    <?php include_once('common_page/links.php'); ?>
</head>

<body>


    <div id="main-wrapper">
        <?php include_once('common_page/header.php'); ?>
        <main>
            <!-- Breadcum Start -->
            <section class="breadcum v1 bg-cover-center" data-background="assets/img/breadcum/bg.jpg">
                <div class="container">
                    <h2><?= $language == 'hi' ? 'करियर' : 'Career' ?></h2>
                    <ul>
                        <li><a href="<?= base_url() ?>"><?= $language == 'hi' ? 'होम' : 'Home' ?></a>
                        </li>
                        <li><?= $language == 'hi' ? 'करियर' : 'Career' ?></li>
                    </ul>
                </div>
            </section>
            <!-- Breadcum End -->
            <section class="py-5 mb-5">
                <div class="container">
                    <div class="text-center mb-4">
                        <h2 class="fw-bold text-uppercase">
                            <?= $language == 'hi' ? 'ओपनिंग वर्तमान ' : 'Current Opening' ?>
                        </h2>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered align-middle" style="background-color: #fff;">
                            <thead style="background-color: #01AEEE; color: white;">
                                <tr class="text-center">
                                    <th style="width: 5%;"><?= $language == 'hi' ? 'क्रमांक' : 'Sr. No.' ?></th>
                                    <th style="width: 15%;"><?= $language == 'hi' ? 'नाम' : 'Name' ?></th>
                                    <th style="width: 15%;"><?= $language == 'hi' ? 'लोकेशन' : 'Location' ?>
                                    </th>
                                    <th style="width: 15%;">
                                        <?= $language == 'hi' ? 'योग्यता' : 'Qualification' ?>
                                    </th>
                                    <th style="width: 40%;">
                                        <?= $language == 'hi' ? 'जॉब रिस्पांसिबिलिटी' : 'Job Responsibility' ?>
                                    </th>
                                    <th style="width: 10%;">&nbsp;</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i = 1; ?>
                                <?php foreach ($jobs as $data): ?>
                                    <?php if ($data->status == 'active'): ?>
                                        <tr>
                                            <td class="text-center"><?= $i++ ?></td>
                                            <td><?= $language == 'hi' ? $data->hindi_position_name : $data->position_name ?>
                                            </td>
                                            <td><?= $language == 'hi' ? $data->hindi_job_location : $data->job_location ?>
                                            </td>
                                            <td><?= $language == 'hi' ? $data->hindi_qualification : $data->qualification ?>
                                            </td>
                                            <td>
                                                <?= $language == 'hi' ? $data->hindi_job_responsibility : $data->job_responsibility ?>
                                            </td>
                                            <td class="text-center">
                                                <a href="#" class="btn btn-sm text-white apply-btn"
                                                    style="background-color:#01AEEE;" data-bs-toggle="modal"
                                                    data-bs-target="#applyJobModal" data-job-id="<?= $data->id ?>"
                                                    data-position="<?= $language == 'hi' ? $data->hindi_position_name : $data->position_name ?>">
                                                    <?= $language == 'hi' ? 'अभी अप्लाई करें' : 'Apply Now' ?>
                                                </a>
                                            </td>
                                        </tr>
                                    <?php else: ?>
                                        <div>
                                            <p>Currently Job Not Avilabile</p>
                                        </div>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                                <!-- Example Row 2 -->

                            </tbody>
                        </table>
                    </div>
                </div>
            </section>
            <!-- 🟢 Job Apply Modal -->
            <div class="modal fade" id="applyJobModal" tabindex="-1" aria-labelledby="applyJobModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header" style="background-color:#01AEEE; color:white;">
                            <h5 class="modal-title" id="applyJobModalLabel">
                                <?= $language == 'hi' ? 'जॉब के लिए आवेदन करें' : 'Apply for Job' ?>
                            </h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <form id="jobApplyForm">
                                <input type="hidden" name="job_id" id="job_id">

                                <div class="mb-3">
                                    <label class="form-label"><?= $language == 'hi' ? 'नाम' : 'Full Name' ?></label>
                                    <input type="text" name="name" class="form-control" required>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label"><?= $language == 'hi' ? 'ईमेल' : 'Email' ?></label>
                                    <input type="email" name="email" class="form-control" required>
                                </div>

                                <div class="mb-3">
                                    <label
                                        class="form-label"><?= $language == 'hi' ? 'फोन नंबर' : 'Phone Number' ?></label>
                                    <input type="text" name="phone" class="form-control" maxlength="10" pattern="\d{10}"
                                        title="Please enter a 10-digit phone number" required
                                        oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 10);">
                                </div>

                                <div class="mb-3">
                                    <label
                                        class="form-label"><?= $language == 'hi' ? 'रिज़्यूमे अपलोड करें (PDF)' : 'Upload Resume (PDF)' ?></label>
                                    <input type="file" name="resume" accept=".pdf,.doc,.docx" class="form-control"
                                        required>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label"><?= $language == 'hi' ? 'इन्फो' : 'Info' ?></label>
                                    <textarea name="info" id="info" class="form-control"></textarea>
                                </div>

                                <button type="submit" class="btn w-100 text-white" style="background-color:#01AEEE;">
                                    <?= $language == 'hi' ? 'सबमिट करें' : 'Submit' ?>
                                </button>
                            </form>


                        </div>
                    </div>
                </div>
            </div>
            <div class="position-fixed bottom-0 end-0 p-3" style="z-index: 9999">
                <div id="toastMsg" class="toast align-items-center text-white border-0" role="alert"
                    aria-live="assertive" aria-atomic="true">
                    <div class="d-flex">
                        <div class="toast-body"></div>
                        <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"
                            aria-label="Close"></button>
                    </div>
                </div>
            </div>
        </main>

        <?php include_once('common_page/footer.php'); ?>
    </div>
    <?php include_once('common_page/script.php'); ?>

    <script>
        $(document).ready(function () {

            // 🟢 When "Apply Now" is clicked
            $(".apply-btn").on("click", function () {
                let jobId = $(this).data("job-id");
                let position = $(this).data("position");

                $("#job_id").val(jobId);
                $("#position_name").val(position);
                $("#applyMsg").html('');
                $("#jobApplyForm")[0].reset();
            });

            // 🟢 Function to show Bootstrap toast
            function showToast(message, type = 'success') {
                let toast = $("#toastMsg");
                let bgClass = (type === 'success') ? 'bg-success' :
                    (type === 'error') ? 'bg-danger' : 'bg-primary';

                toast.removeClass('bg-success bg-danger bg-primary').addClass(bgClass);
                toast.find('.toast-body').html(message);

                let bsToast = new bootstrap.Toast(toast[0]);
                bsToast.show();
            }

            // 🟢 Handle form submit via AJAX
            $("#jobApplyForm").on("submit", function (e) {
                e.preventDefault();
                let formData = new FormData(this);

                // 🟡 Immediately hide modal on submit click
                $("#applyJobModal").modal("hide");

                $.ajax({
                    url: "<?= base_url('career/submit_application') ?>",
                    type: "POST",
                    data: formData,
                    contentType: false,
                    processData: false,
                    dataType: "json",
                    beforeSend: function () {
                        showToast('<?= $language == 'hi' ? 'कृपया प्रतीक्षा करें...' : 'Please wait...' ?>', 'info');
                    },
                    success: function (response) {
                        if (response.status === "success") {
                            showToast(response.message, 'success');
                            $("#jobApplyForm")[0].reset();
                        } else {
                            showToast(response.message, 'error');
                        }
                    },
                    error: function () {
                        showToast('<?= $language == 'hi' ? 'कुछ गलत हो गया।' : 'Something went wrong.' ?>', 'error');
                    }
                });
            });
        });
    </script>



</body>

</html>