<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="keywords" content="Maalav Milk - Maalav Milk home page" />
    <meta name="description" content="Maalav Milk - Maalav Milk home page" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

    <title><?= $language == 'hi' ? 'हमसे संपर्क करें | मालव मिल्क' : 'Contact Us | Maalav Milk' ?> </title>
    <?php include_once('common_page/links.php'); ?>
</head>

<body>


    <div id="main-wrapper">
        <?php include_once('common_page/header.php'); ?>
        <main>
            <!-- Breadcum Start -->
            <section class="breadcum v1 bg-cover-center" data-background="assets/img/breadcum/bg.jpg">
                <div class="container">
                    <h2><?= $language == 'hi' ? 'हमसे संपर्क करें' : 'Contact Us' ?></h2>
                    <ul>
                        <li><a href="<?= base_url() ?>"><?= $language == 'hi' ? 'होम' : 'Home' ?></a></li>
                        <li><?= $language == 'hi' ? 'हमसे संपर्क करें' : 'Contact Us' ?></li>
                    </ul>
                </div>
            </section>
            <!-- Breadcum End -->
            <!-- Send Message Start -->
            <section class="send-message v1">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="left-content">
                                <div class="section-title v1">
                                    <h6>
                                        <?= $language == 'hi' ? 'मेसेज भेजें' : 'Send Message' ?>

                                    </h6>
                                    <h2>
                                        <?= $language == 'hi' ? 'बस एक त्वरित कोई प्रश्न है?' : 'Just Have a Quick Any Questions?' ?>

                                    </h2>
                                    <p>
                                        <?= $language == 'hi' ? 'गायें दूध देती हैं जिसे इकट्ठा करके ताज़ा आपके घर पहुँचाया जाता है। मालव
                                        दूध स्वस्थ, घास चरने वाली गायों से आता है जिनकी प्राकृतिक रूप से देखभाल की जाती है। यह दूध
                                        कैल्शियम, प्रोटीन और विटामिन जैसे पोषक तत्वों से भरपूर होता है, जो इसे
                                        दैनिक सेवन के लिए आदर्श बनाता है। हमारी प्रसंस्करण विधियाँ यह सुनिश्चित करती हैं कि दूध का
                                        प्राकृतिक स्वाद और शुद्धता बनी रहे।' : 'Cows produce milk which is collected and delivered fresh to your home. Malav
                                        Milk comes from healthy, grass-fed cows that are cared for naturally. The milk
                                        is rich in nutrients like calcium, protein, and vitamins, making it ideal for
                                        daily consumption. Our processing methods ensure that the milk retains its
                                        natural taste and purity.' ?>

                                    </p>
                                </div>
                                <div class="socials-links-box">
                                    <ul>
                                        <li><a href="#"><i class="fa-brands fa-facebook"></i></a></li>
                                        <li><a href="#"><i class="fa-brands fa-square-x-twitter"></i></a></li>
                                        <li><a href="#"><i class="fa-brands fa-linkedin"></i></a></li>
                                        <li><a href="#"><i class="fa-brands fa-instagram"></i></a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <form id="contactForm" method="POST" class="message-form">
                                <ul>
                                    <li>
                                        <h5><?= $language == 'hi' ? 'आपका नाम' : 'Your Name' ?></h5>
                                        <input type="text" name="name" class="form-control"
                                            placeholder="<?= $language == 'hi' ? 'आपका नाम' : 'Your Name' ?>">
                                    </li>
                                    <li>
                                        <h5><?= $language == 'hi' ? 'आपका ईमेल' : 'Your Email' ?></h5>
                                        <input type="email" name="email" class="form-control"
                                            placeholder="alma.lawson@example.com">
                                    </li>
                                    <li>
                                        <h5><?= $language == 'hi' ? 'आपका फोन' : 'Your Phone' ?></h5>
                                        <input type="text" name="phone" class="form-control"
                                            placeholder="<?= $language == 'hi' ? '10-अंकीय संख्या दर्ज करें' : 'Enter 10-digit number' ?>"
                                            oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 10);" />
                                    </li>
                                    <li>
                                        <h5><?= $language == 'hi' ? 'संदेश' : 'Message' ?></h5>
                                        <textarea name="message"
                                            placeholder="<?= $language == 'hi' ? 'इसके साथ ही हमारे सामने एक समस्या थी' : 'Simultaneously we had a problem' ?>"></textarea>
                                    </li>
                                </ul>
                                <button type="submit"
                                    class="btn-anime v2"><?= $language == 'hi' ? 'मेसेज भेजें' : 'send message' ?></button>

                            </form>
                        </div>
                    </div>
                    <!-- Toast Notification Container -->
                    <div id="toast" style="
                                    visibility: hidden;
                                    min-width: 250px;
                                    background: #333;
                                    color: #fff;
                                    text-align: left;
                                    border-radius: 8px;
                                    padding: 16px;
                                    position: fixed;
                                    right: -23rem;
                                    bottom: 20px;
                                    z-index: 9999;
                                    transition: all 0.5s ease;
                                ">
                    </div>

                </div>
            </section>
            <!-- Send Message End -->
            <!-- Contact US Start -->
               <section class="contact-us v1 bg-cover-center">
                <div class="container">
                    <div class="section-title-center-white v1">
                        <h6 class="text-dark"><?= $language == 'hi' ? 'हमसे संपर्क करें' : 'Contact Us' ?></h6>
                        <h2 class="text-dark"><?= $language == 'hi' ? 'संपर्क में रहो' : 'Get In Touch' ?></h2>
                    </div>
                    <div class="row">
                        <div class="col-lg-3 col-md-4 col-sm-12">
                            <div class="info-content text-center">

                                <div>
                                    <span class="my-icon icon-phone"></span>
                                </div>
                                <h4 class="text-white fw-bold">Give us a call</h4>
                                <p><a href="tel:+91 8057900900" class="text-white">+91 8057900900</a></p>
                                <p class="text-white">Toll Free - <a href="tel:+91 8057900900" class="text-white">1800
                                        5322 600</a></p>
                                <p class="text-white fw-bold">Working hours :</p>
                                <p class="text-white">09:30AM to 05:30PM</p>
                                <p class="text-white">Monday-Saturday</p>
                                <p class="text-white">(Except Public Holidays)</p>



                            </div>
                        </div>
                        <div class="col-lg-3 col-md-4 col-sm-12">
                            <div class="info-content text-center h-100">
                                <div>
                                    <span class="my-icon icon-envelope"></span>
                                </div>
                                <h4 class="text-white fw-bold">Drop us a line</h4>
                                <p><a href="mailto:info@maalavmilk.com" class="text-white">info@maalavmilk.com</a></p>

                                <!--<p class="text-white fw-bold" style="margin-top: 5rem;">For Grievance Redressal</p>-->
                                <!--<p><a href="mailto:go@maalavmilk.com" class="text-white">go@maalavmilk.com</a></p>-->
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-4 col-sm-12">
                            <div class="info-content text-center">
                                <div>
                                    <span class="my-icon icon-location-dot"></span>
                                </div>
                                <h4 class="text-white fw-bold">Visit our office</h4>
                                <p class="text-white">Old A B Road, Near Prabhat Bread Factory Talwara, Champapura,
                                    Biaora,Rajgarh, Rajgarh, Madhya Pradesh, India, 465674</p>

                            </div>
                        </div>
                        <div class="col-lg-3 col-md-4 col-sm-12">
                            <div class="info-content text-center">
                                <div>
                                    <i class="my-icon fa-regular fa-handshake"></i>
                                </div>
                                <h4 class="text-white fw-bold">Stay connected on</h4>
                                <div class="mt-5">
                                    <div class="social-icon d-flex justify-content-center gap-3">
                                        <a href="#" class="text-white"><i class="fa-brands fa-facebook"></i></a>
                                        <a href="#" class="text-white"><i class="fa-brands fa-square-x-twitter"></i></a>
                                         <a href="#" class="text-white"><i class="fa-brands fa-youtube"></i></a>
                                    </div>
                                    <div class="social-icon d-flex justify-content-center gap-3 mt-2">
                                        <a href="#" class="text-white"><i class="fa-brands fa-linkedin"></i></a>
                                        <a href="#" class="text-white"><i class="fa-brands fa-instagram"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>


                    </div>
                </div>
            </section>
            <!-- Contact US End -->
            <!-- Contact Map Start -->
            <!--<div class="contact-map v1 pb-xl-spach">-->
            <!--    <iframe-->
            <!--        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d455.9708601606978!2d76.89583517611027!3d23.897883763599236!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x397b6b7bcfd7e079%3A0x6889297406dc92d9!2sMaalav%20Mahila%20Milk%20Producer%20Company%20Ltd!5e0!3m2!1sen!2sin!4v1760517344214!5m2!1sen!2sin"-->
            <!--        width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy"-->
            <!--        referrerpolicy="no-referrer-when-downgrade"></iframe>-->
            <!--</div>-->
            <!-- Contact Map End -->
        </main>

        <?php include_once('common_page/footer.php'); ?>
    </div>
    <?php include_once('common_page/script.php'); ?>


    <script>
        $(document).ready(function () {
            $("#contactForm").on("submit", function (e) {
                e.preventDefault(); // Stop normal form submission

                $(".error").html(""); // Clear errors


                $.ajax({
                    url: "<?= base_url('contact/save') ?>",
                    type: "POST",
                    data: $(this).serialize(),
                    dataType: "json",
                    success: function (response) {
                        if (response.status === "error") {
                            $.each(response.errors, function (key, value) {
                                $("#error-" + key).html(value);
                            });
                        } else if (response.status === "success") {
                            $("#contactForm")[0].reset();
                            showToast(response.message, "success");
                        }
                    },
                    error: function () {
                        showToast("Something went wrong. Try again.", "error");
                    }
                });
            });

            // Toast function
            function showToast(message, type) {
                var toast = $("#toast");
                toast.html(message);

                if (type === "success") {
                    toast.css("background", "#28a745");
                } else {
                    toast.css("background", "#dc3545");
                }

                toast.css("visibility", "visible").css("right", "20px");

                setTimeout(function () {
                    toast.css("right", "-23rem");
                }, 3000); // hide after 3 seconds
            }
        });
    </script>
</body>

</html>