<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="keywords" content="Maalav Milk - Maalav Milk home page" />
    <meta name="description" content="Maalav Milk - Maalav Milk home page" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

    <title>
        <?= $language == 'hi' ? 'डिविडेंड हिस्ट्री | मालव दूध' : 'Dividend History | Maalav Milk' ?>

    </title>
    <?php include_once('common_page/links.php'); ?>
</head>

<body>


    <div id="main-wrapper">
        <?php include_once('common_page/header.php'); ?>
        <main>
            <!-- Breadcum Start -->
            <section class="breadcum v1 bg-cover-center" data-background="assets/img/breadcum/bg.jpg">
                <div class="container">
                    <h2><?= $language == 'hi' ? 'डिविडेंड हिस्ट्री' : 'Dividend History' ?></h2>
                    <ul>
                        <li><a href="<?= base_url() ?>"><?= $language == 'hi' ? 'होम' : 'Home' ?></a></li>
                        <li><?= $language == 'hi' ? 'डिविडेंड हिस्ट्री' : 'Dividend History' ?></li>
                    </ul>
                </div>
            </section>
            <!-- Breadcum End -->
            <section class="our-services v2 pb-4">
                <div class="container">
                    <div class="section-title v1 text-center">
                        <h2><?= $language == 'hi' ? 'डिविडेंड हिस्ट्री' : 'Dividend History' ?></h2>
                    </div>
                    <div class="row g-4">

                        <?php foreach ($dividend as $data): ?>
                            <div class="col-md-3 col-sm-6">
                                <div class="div-card">
                                    <div class="div-header">
                                        <?= $language == 'hi' ? 'वित्तीय वर्ष' : 'Financial Year' ?> : <span
                                            class="float-end"><?= $language == 'hi' ? $data->year : $data->year ?></span>
                                    </div>
                                    <div class="div-body">
                                        <div class="row mb-3">
                                            <div class="col-6">
                                                <div class="title">
                                                    <?= $language == 'hi' ? 'शेयरों की संख्या' : 'No. of Shares' ?>
                                                </div>
                                                <div class="value">
                                                    <?= $data->shares ?>
                                                </div>
                                            </div>
                                            <div class="col-6">
                                                <div class="title"><?= $language == 'hi' ? 'कुल राशि' : 'Total Amount' ?>
                                                </div>
                                                <div class="value"><?= $data->total_amount ?></div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="title col-9">
                                                <?= $language == 'hi' ? 'प्रति शेयर डिविडेंड (रु. में)' : 'Dividend Per Share (In Rs.)' ?>
                                            </div>
                                            <div class="value col-3">₹ <?= $data->rate ?></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>

                </div>
            </section>
            <section class="our-services v2 mb-5 pt-2">
                <div class="container">
                    <div class="section-title v1 text-center">
                        <h2><?= $language == 'hi' ? 'अवैतनिक' : 'Unpaid' ?></h2>
                    </div>

                    <div class="row g-4">

                        <!-- Example Item (repeat inside foreach loop) -->
                        <?php foreach ($unpaid as $data): ?>
                            <div class="col-md-4">
                                <a href="<?= base_url($data->featured_file) ?>" class="text-decoration-none">
                                    <div class="d-flex align-items-center p-3 bg-light border rounded shadow-sm">

                                        <!-- PDF Icon -->
                                        <div class="me-3">
                                            <img src="<?= base_url('assets/img/pdf.png') ?>" width="60" alt="PDF">
                                        </div>

                                        <!-- Title -->
                                        <div>
                                            <h6 class="mb-0 text-primary fw-bold"
                                                style="color: var(--theme-color) !important;">
                                                <?= $language == 'hi' ? $data->hindi_title : $data->title ?>
                                                <?= $language == 'hi' ? $data->year : $data->year ?>
                                            </h6>

                                        </div>

                                    </div>
                                </a>
                            </div>
                        <?php endforeach; ?>

                    </div>
                </div>
            </section>
        </main>

        <?php include_once('common_page/footer.php'); ?>
    </div>
    <?php include_once('common_page/script.php'); ?>
</body>

</html>