<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="keywords" content="Maalav Milk - Maalav Milk home page" />
    <meta name="description" content="Maalav Milk - Maalav Milk home page" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

    <title>
        <?= $language == 'hi' ? 'गैलरी | मालव दूध' : 'Gallery | Maalav Milk' ?>

    </title>
    <?php include_once('common_page/links.php'); ?>
</head>

<body>


    <div id="main-wrapper">
        <?php include_once('common_page/header.php'); ?>
        <main>
            <!-- Breadcum Start -->
            <section class="breadcum v1 bg-cover-center" data-background="assets/img/breadcum/bg.jpg">
                <div class="container">
                    <h2> <?= $language == 'hi' ? 'गैलरी' : 'Gallery' ?></h2>
                    <ul>
                        <li><a href="<?= base_url() ?>"><?= $language == 'hi' ? 'होम' : 'Home' ?></a></li>
                        <li><?= $language == 'hi' ? 'गैलरी' : 'Gallery' ?></li>
                    </ul>
                </div>
            </section>
            <!-- Breadcum End -->

            <section class="gallery-display v1 pb-xl-spach">
                <div class="container">
                    <!-- ✅ CATEGORY FILTER BUTTONS -->
                    <div class="gallery-btns mb-4">
                        <ul class="category-filter">
                            <li>
                                <button class="active" data-filter="all">
                                    <?= $language == 'hi' ? 'सभी दिखाएं' : 'Show All' ?>
                                </button>
                            </li>
                            <?php
                            $categories = [];
                            foreach ($gallery as $item):
                                if (!in_array($item->gallery_category, $categories)):
                                    $categories[] = $item->gallery_category;
                                    $category_name = ($language == 'hi') ? $item->hindi_gallery_category : $item->gallery_category;
                                    ?>
                                    <li>
                                        <button data-filter="<?= strtolower($item->gallery_category) ?>">
                                            <?= ucfirst($category_name) ?>
                                        </button>
                                    </li>
                                    <?php
                                endif;
                            endforeach;
                            ?>
                        </ul>

                        <!-- ✅ YEAR FILTER BUTTONS -->
                        <ul class="year-filter">
                            <li>
                                <button class="active" data-year="all">
                                    <?= $language == 'hi' ? 'सभी साल' : 'All Years' ?>
                                </button>
                            </li>
                            <?php
                            $years = [];
                            foreach ($gallery as $item):
                                if (!in_array($item->year, $years)):
                                    $years[] = $item->year;
                                    ?>
                                    <li>
                                        <button data-year="<?= $item->year ?>">
                                            <?= ucfirst($item->year) ?>
                                        </button>
                                    </li>
                                    <?php
                                endif;
                            endforeach;
                            ?>
                        </ul>
                    </div>

                    <!-- ✅ GALLERY GRID -->
                    <div class="row gallery-items">
                        <?php foreach ($gallery as $g): ?>
                            <div class="col-md-3 mb-4 gallery-card" data-category="<?= strtolower($g->gallery_category) ?>"
                                data-year="<?= $g->year ?>">
                                <a class="gallery-content venobox" data-gall="gallery-demos"
                                    href="<?= base_url($g->gallery_image) ?>">
                                    <img src="<?= base_url($g->gallery_image) ?>" alt="gallery-img"
                                        class="img-fluid rounded shadow-sm" />
                                </a>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </section>

        </main>
        <?php include_once('common_page/footer.php'); ?>
    </div>
    <?php include_once('common_page/script.php'); ?>

    <script src="https://cdn.jsdelivr.net/npm/shufflejs@6.1.0/dist/shuffle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/venobox@2.0.6/dist/venobox.min.js"></script>

    <!-- ✅ FILTER SCRIPT -->
    <script>
        $(document).ready(function () {
            let activeCategory = "all";
            let activeYear = "all";

            // 🟢 Category filter
            $(".category-filter button").on("click", function () {
                $(".category-filter button").removeClass("active");
                $(this).addClass("active");
                activeCategory = $(this).data("filter");

                // Reset year to "All" whenever category changes
                $(".year-filter button").removeClass("active");
                $('.year-filter button[data-year="all"]').addClass("active");
                activeYear = "all";

                updateYearButtons(); // ✅ update year list dynamically
                filterGallery();
            });

            // 🟢 Year filter
            $(".year-filter").on("click", "button", function () {
                $(".year-filter button").removeClass("active");
                $(this).addClass("active");
                activeYear = $(this).data("year");
                filterGallery();
            });

            // 🟢 Filtering function
            function filterGallery() {
                $(".gallery-card").each(function () {
                    const category = $(this).data("category");
                    const year = $(this).data("year");

                    const showCategory = (activeCategory === "all" || category === activeCategory);
                    const showYear = (activeYear === "all" || year == activeYear);

                    if (showCategory && showYear) {
                        $(this).fadeIn(300);
                    } else {
                        $(this).fadeOut(300);
                    }
                });
            }

            // 🟢 Update year buttons dynamically based on category
            function updateYearButtons() {
                let availableYears = [];

                // Clear all year buttons except "All"
                $(".year-filter li:not(:first)").remove();

                // Find available years for selected category
                $(".gallery-card").each(function () {
                    const category = $(this).data("category");
                    const year = $(this).data("year");

                    if (activeCategory === "all" || category === activeCategory) {
                        if (!availableYears.includes(year)) {
                            availableYears.push(year);
                        }
                    }
                });

                // Sort years descending (optional)
                availableYears.sort((a, b) => b - a);

                // Append only unique years
                availableYears.forEach(year => {
                    $(".year-filter").append(
                        `<li><button data-year="${year}">${year}</button></li>`
                    );
                });
            }
        });
    </script>
</body>

</html>