<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8" />
  <meta name="keywords" content="Maalav Milk - Maalav Milk home page" />
  <meta name="description" content="Maalav Milk - Maalav Milk home page" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />

  <title><?= $language == 'hi' ? 'होम | मालव दूध' : 'Home | Maalav Milk' ?></title>
  <?php include_once('common_page/links.php'); ?>
</head>

<body>


  <div id="main-wrapper">
    <?php include_once('common_page/header.php'); ?>
    <main>
      <!-- Banner Start -->
      <section id="module" class="banner v1">
        <div class="swiper mySwiper">
          <div class="swiper-wrapper">
            <?php foreach ($slider as $data): ?>
              <div class="swiper-slide">
                <div class="content">
                  <span class="title"><?= $language == 'hi' ? $data->hindi_title : $data->title ?></span>
                  <span class="description"><?= $language == 'hi' ? $data->hindi_detail : $data->detail ?></span>
                </div>
                <div class="img">
                  <img src="<?= base_url($data->slider_image) ?>" />
                </div>
              </div>
            <?php endforeach; ?>
          </div>
          <div class="swiper-button-next">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
              stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"
              class="lucide lucide-move-right-icon lucide-move-right">
              <path d="M18 8L22 12L18 16" />
              <path d="M2 12H22" />
            </svg>
          </div>
          <div class="swiper-button-prev">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
              stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"
              class="lucide lucide-move-left-icon lucide-move-left">
              <path d="M6 8L2 12L6 16" />
              <path d="M2 12H22" />
            </svg>
          </div>
          <div class="swiper-pagination"></div>
        </div>
      </section>
      <!-- Banner End -->
      <!-- Our Services Start -->
     <section class="our-services v1" id="our_services">
        <div class="container">
          <div class="section-title-center v1">
            <h6><?= $language == 'hi' ? 'हमारी सेवाएँ' : 'Our Services' ?></h6>
            <h2><?= $language == 'hi' ? '' : '' ?> </h2>
          </div>
          <div class="row justify-content-center">
            <?php foreach ($services as $data): ?>
              <div class="col-md-6 col-xl-3">
                <div class="service-card">
                  <div class="text-center">
                    <img src="<?= base_url($data->featured_image_one) ?>" alt="image" style="width: 14rem;">
                  </div>
                  <h4 class="mt-1">
                    <a href="<?= base_url('service/' . $data->slug) ?>">
                      <?= $language == 'hi' ? $data->hindi_service_name : $data->service_name ?>

                    </a>
                  </h4>
                  <p>
                    <?= word_limiter(($language == 'hi' ? $data->hindi_content_one : $data->content_one), 20); ?>
                  </p>
                </div>
              </div>

            <?php endforeach; ?>
          </div>

        </div>
      </section>
      <!-- Our Product Start -->
      <section class="our-services v1" id="our_services">
        <div class="container">
          <div class="section-title-center v1">
            <h6><?= $language == 'hi' ? 'हमारी प्रोडक्ट' : 'Our Product' ?></h6>
            <h2><?= $language == 'hi' ? '' : '' ?> </h2>
          </div>
          <div class="row justify-content-center">
            <?php foreach ($products as $data): ?>
              <div class="col-md-6 col-xl-3">
                <div class="service-card">
                  <div class="text-center">
                    <img src="<?= base_url($data->featured_image_one) ?>" alt="image" style="width: 14rem;">
                  </div>
                  <h4 class="mt-1">
                    <a href="<?= base_url('our-product/' . $data->slug) ?>">
                      <?= $language == 'hi' ? $data->hindi_product_name : $data->product_name ?>

                    </a>
                  </h4>
                  <p>
                    <?= word_limiter(($language == 'hi' ? $data->hindi_content_one : $data->content_one), 20); ?>
                  </p>
                </div>
              </div>

            <?php endforeach; ?>
          </div>

        </div>
      </section>
      <!-- Our Product End -->
      <!-- Our Services End -->
      <?php if ($counters): ?>
        <section class="fun-fact bg-cover-center bg-honey-shap-left v2">
          <div class="container">
            <ul class="text-center" id="counter-section">
              <li class="d-flex justify-content-center">
                <div><img src="<?= base_url('assets/img/map.png') ?>" alt="Districts" width="100"></div>
                <div class="text text-dark">
                  <h3><span id="total_district" class="counter text-dark">0</span></h3>
                  <h5 class="text-dark">Total Districts</h5>
                </div>
              </li>

              <li class="d-flex justify-content-center">
                <div><img src="<?= base_url('assets/img/village.png') ?>" alt="Villages" width="100"></div>
                <div class="text">
                  <h3><span id="total_village" class="counter text-dark">0</span></h3>
                  <h5 class="text-dark">Total Villages</h5>
                </div>
              </li>

              <li class="d-flex justify-content-center">
                <div><img src="<?= base_url('assets/img/diversity.png') ?>" alt="Team" width="100"></div>
                <div class="text">
                  <h3><span id="team_member" class="counter text-dark">0</span></h3>
                  <h5 class="text-dark">Team Members</h5>
                </div>
              </li>

              <li class="d-flex justify-content-center">
                <div><img src="<?= base_url('assets/img/women.png') ?>" alt="Females" width="100"></div>
                <div class="text">
                  <h3><span id="female_member" class="counter text-dark">0</span></h3>
                  <h5 class="text-dark">Females Members</h5>
                </div>
              </li>

              <li class="d-flex justify-content-center">
                <div><img src="<?= base_url('assets/img/milk.png') ?>" alt="Milk" width="100"></div>
                <div class="text">
                  <h3><span id="milk_qty" class="counter text-dark">0</span></h3>
                  <h5 class="text-dark">Milk Qty (LLPD)</h5>
                </div>
              </li>
            </ul>

          </div>
        </section>
      <?php endif; ?>
      <!-- map image -->
      <section class="map-image d-flex justify-content-center align-items-center">
        <img src="<?= base_url('assets/img/1737180529.jpg') ?>" alt="map">
      </section>
      <!-- Why Us Start-->
      <section class="why-us v1">
        <div class="container">
          <div class="section-title-center v1">
            <h6><?= $language == 'hi' ? 'क्यों चुनें हमें' : 'Why Us' ?></h6>
            <h2>
              <?= $language == 'hi' ? 'हमारे प्रोडक्ट्स क्यों चुनें?' : 'Why Choose Maalav' ?>

            </h2>
          </div>
          <div class="row">
            <div class="col-xl-4">
              <div class="big-pic wow animate__fadeInUp" data-wow-duration="1.5s" data-wow-delay="0.5s">
                <img src="<?= base_url() ?>assets/img/why-us/big-pic.jpg" alt="pic" />
              </div>
            </div>
            <div class="col-md-6 col-xl-4 order-xl-first">
              <ul class="list-1">
                <li class="wow animate__fadeInUp" data-wow-duration="1.5s" data-wow-delay="0.5s">
                  <div class="my-icon text-white fa-solid fa-leaf"></div>
                  <div class="text">
                    <h5><?= $language == 'hi' ? 'सतत आजीविका' : 'Sustainable Livelihoods' ?></h5>
                    <p>
                      <?= $language == 'hi' ? 'मालव मिल्क किसानों को स्थिर आय प्रदान करके सशक्त बनाता है - जिससे वे मिलकर
                      एक स्थायी भविष्य का निर्माण कर सकते हैं।' : 'Maalav Milk empowers farmers with steady income — building a sustainable
                      future together.' ?>

                    </p>
                  </div>
                </li>
                <li class="wow animate__fadeInUp" data-wow-duration="1.5s" data-wow-delay="0.8s">
                  <div class="my-icon text-white fa-solid fa-shield-alt"></div>
                  <div class="text">
                    <h5><?= $language == 'hi' ? 'विश्वसनीय दूध स्रोत' : 'Trusted Milk Source' ?></h5>
                    <p>
                      <?= $language == 'hi' ? 'हर बूँद जिस पर आप भरोसा कर सकते हैं - मालव दूध, शुद्ध
                      अच्छाई का आपका विश्वसनीय स्रोत।' : ' Every drop you can trust — Maalav Milk, your reliable source of pure
                      goodness.' ?>

                    </p>
                  </div>
                </li>
                <li class="wow animate__fadeInUp" data-wow-duration="1.5s" data-wow-delay="1s">
                  <div class="my-icon text-white fa-solid fa-home"></div>
                  <div class="text">
                    <h5>
                      <?= $language == 'hi' ? 'हर घर को पोषण देना' : 'Nourishing Every Home' ?>

                    </h5>
                    <p>
                      <?= $language == 'hi' ? 'हर घर में स्वास्थ्य और पोषण लाना - एक गिलास मालव दूध
                      एक बार में।' : 'Bringing health and nutrition to every home — one glass of Maalav Milk at a
                      time.' ?>

                    </p>
                  </div>
                </li>
              </ul>
            </div>
            <div class="col-md-6 col-xl-4">
              <ul class="list-2">
                <li class="wow animate__fadeInUp" data-wow-duration="1.5s" data-wow-delay="0.5s">
                  <div class="my-icon text-white fa-solid fa-chart-line"></div>
                  <div class="text">
                    <h5>
                      <?= $language == 'hi' ? 'ग्रामीण अर्थव्यवस्था को मजबूत बनाना' : 'Strengthening Rural Economy' ?>

                    </h5>
                    <p>
                      <?= $language == 'hi' ? 'गाँवों को सशक्त बनाना, किसानों का उत्थान करना - मालव दूध ग्रामीण
                      अर्थव्यवस्था को मज़बूत करता है' : 'Empowering villages, uplifting farmers — Maalav Milk strengthens the rural
                      economy' ?>

                    </p>
                  </div>
                </li>
                <li class="wow animate__fadeInUp" data-wow-duration="1.5s" data-wow-delay="0.8s">
                  <div class="my-icon text-white fa-solid fa-tint"></div>
                  <div class="text">
                    <h5>
                      <?= $language == 'hi' ? 'शुद्ध और ताजा' : 'Pure & Fresh' ?>

                    </h5>
                    <p>
                      <?= $language == 'hi' ? '
                      खेत से गिलास तक - मालव दूध, हमेशा शुद्ध, हमेशा ताज़ा।' : 'From farm to glass — Maalav Milk, always pure, always fresh.' ?>

                    </p>
                  </div>
                </li>
                <li class="wow animate__fadeInUp" data-wow-duration="1.5s" data-wow-delay="1s">
                  <div class="my-icon text-white fa-solid fa-network-wired"></div>
                  <div class="text">
                    <h5>
                      <?= $language == 'hi' ? 'गांवों को जोड़ना' : 'Connecting Villages' ?>

                    </h5>
                    <p>
                      <?= $language == 'hi' ? 'पवित्रता और प्रगति के माध्यम से गाँवों को एकजुट करना - मालव मिल्क दिलों
                      और समुदायों को जोड़ता है।' : 'Uniting villages through purity and progress — Maalav Milk connects hearts
                      and communities.' ?>

                    </p>
                  </div>
                </li>
              </ul>
            </div>
          </div>
        </div>
      </section>
      <?php if ($directors): ?>
        <section id="team" class="team-area">
          <div class="container">
            <div class="site-heading text-center mb-4">
              <div class="section-title-center v1">

                <h2><?= $language == 'hi' ? 'बोर्ड ऑफ़ डायरेक्टर्स' : 'Board of Directors' ?></h2>
              </div>

            </div>

            <div class="owl-carousel team-carousel owl-theme">
              <?php foreach ($team as $data): ?>
                <?php if ($data->category == 'Board of Directors'): ?>
                  <div class="single-team">


                    <div class="team-img">
                      <img src="<?= base_url($data->featured_image) ?>" alt="Team Member" />
                    </div>


                    <div class="team-content">
                      <h3>
                        <?= $language == 'hi' ? $data->hindi_name : $data->name ?>
                      </h3>
                      <p><?= $language == 'hi' ? $data->hindi_designation : $data->designation ?></p>
                    </div>
                  </div>
                <?php endif; ?>
              <?php endforeach; ?>
            </div>
          </div>
        </section>
      <?php endif; ?>
      <?php if ($management): ?>
        <section id="team" class="team-area">
          <div class="container">
            <div class="site-heading text-center mb-4">
              <div class="section-title-center v1">

                <h2><?= $language == 'hi' ? 'की मैनेजमेंट' : 'Key Management' ?></h2>
              </div>

            </div>

            <div class="owl-carousel team-carousel owl-theme">
              <?php foreach ($team as $data): ?>
                <?php if ($data->category == 'Key Management'): ?>
                  <div class="single-team">

                    <div class="team-img">
                      <img src="<?= base_url($data->featured_image) ?>" alt="Team Member" />
                    </div>


                    <div class="team-content">
                      <h3>
                        <?= $language == 'hi' ? $data->hindi_name : $data->name ?>
                      </h3>
                      <p><?= $language == 'hi' ? $data->hindi_designation : $data->designation ?></p>
                    </div>
                  </div>
                <?php endif; ?>
              <?php endforeach; ?>
            </div>
          </div>
        </section>
      <?php endif; ?>
      <!-- About Beeberry Start -->
      <section class="about-beeberry v1">
        <div class="container">

          <div class="video-box position-relative text-center">
            <div class="ratio ratio-21x9">
              <iframe id="aboutVideo" src="https://www.youtube.com/embed/8POk3fuha7E?rel=0" title="About Beeberry"
                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                allowfullscreen></iframe>
            </div>
          </div>
        </div>
      </section>
      <!-- About Beeberry End -->

      <!-- Testimonial Start -->
      <?php if ($testimonial): ?>
        <section class="testimonial v1 bg-cover-center" data-background="<?= base_url() ?>assets/img/testimonialbg.png">
          <div class="container">
            <div class="section-title-center-white v1">
              <h6>
                <?= $language == 'hi' ? 'उपयोगकर्ता अनुभव' : 'Testimonials' ?>

              </h6>
              <h2>
                <?= $language == 'hi' ? 'हमारे ग्राहक क्या कह रहे हैं' : 'What Our Customers Are Saying' ?>

              </h2>
            </div>
            <div class="slider">
              <div class="swiper-wrapper">
                <?php foreach ($testimonials as $data): ?>
                  <div class="swiper-slide testimonial-card">
                    <div class="profile">
                      <div class="profile-img">
                        <img src="<?= base_url() . $data->featured_image ?>" alt="profile" />
                      </div>
                      <div class="profile-content">
                        <h6>
                          <?= $language == 'hi' ? $data->hindi_name : $data->name ?>

                        </h6>
                        <p><?= date('d M Y', strtotime($data->date)) ?></p>
                      </div>
                    </div>
                    <p>
                      <?= $language == 'hi' ? $data->hindi_comment : $data->comment ?>

                    </p>
                  </div>
                <?php endforeach; ?>
              </div>
              <button class="prev-btn">
                <span class="my-icon icon-angle-right"></span>
              </button>
              <button class="next-btn">
                <span class="my-icon icon-angle-left"></span>
              </button>
            </div>
          </div>
        </section>
      <?php endif; ?>
      <!-- Testimonial End -->
      <!-- Blog  Start -->
      <?php if ($blog): ?>
        <section class="blog-news v2">
          <div class="container">
            <div class="section-title v1">
              <h6>

                <?= $language == 'hi' ? 'ब्लॉग' : 'Blog' ?>
              </h6>
              <h2><?= $language == 'hi' ? 'हमारे साथ अपडेट रहें' : 'Keep Updated With US' ?>
              </h2>
            </div>
            <div class="row justify-content-center">
              <?php foreach ($blogs as $blog): ?>
                <div class="col-md-6 col-xl-4">
                  <div class="blog-card">
                    <div class="blog-img">
                      <img src="<?= base_url($blog->featured_image) ?>" alt="blog-img">
                    </div>
                    <div class="blog-content">

                      <h6>
                        <span class="my-icon icon-tag"></span>
                        <a href="<?= base_url('blogs/' . $blog->category) ?>">
                          <?= $language == 'hi' ? $blog->hindi_category : $blog->category ?>
                        </a>
                      </h6>
                      <h4>
                        <a href="<?= base_url('blog/' . $blog->slug) ?>">
                          <?= mb_strimwidth($language == 'hi' ? $blog->hindi_title : $blog->title, 0, 40, '...') ?>
                        </a>
                      </h4>
                      <div class="date-link">
                        <h6>
                          <span class="my-icon icon-clock"></span>
                          <?= date('d M Y', strtotime($blog->date ?? date('Y-m-d'))) ?>
                        </h6>
                        <a class="link-btn" href="<?= base_url('blog/' . $blog->slug) ?>"><span
                            class="my-icon icon-arrow-right"></span></a>
                      </div>
                      <button class="left-btn"><span class="my-icon icon-angle-right"></button>
                    </div>
                  </div>
                </div>
              <?php endforeach; ?>
            </div>
            <div class="more-link text-center mt-3">
              <a class="link-anime v1"
                href="<?= base_url('blogs') ?>"><?= $language == 'hi' ? 'और ब्लॉग' : 'More Blogs' ?></a>
            </div>
          </div>
        </section>
      <?php endif; ?>
      <!-- Blog  End -->
      <!--  News Start -->
      <?php if ($newsandevent): ?>
        <section class="blog-news v2 pb-xl-spach">
          <div class="container">
            <div class="section-title v1">
              <h6>

                <?= $language == 'hi' ? 'न्यूज़ और आयोजन' : 'News & Event' ?>
              </h6>
              <h2><?= $language == 'hi' ? 'रोचक लेख प्रतिदिन अपडेट किए जाते हैं' : 'Interesting Articles Updated Daily' ?>
              </h2>
            </div>
            <div class="row justify-content-center">
              <?php foreach ($news as $date): ?>
                <div class="col-md-6 col-xl-4">
                  <div class="blog-card">
                    <div class="blog-img">
                      <img src="<?= base_url($date->featured_image) ?>" alt="News-img">
                    </div>
                    <div class="blog-content">

                      <h6>
                        <span class="my-icon icon-tag"></span>
                        <a href="<?= base_url('news-and-event-details/' . $date->category) ?>">
                          <?= $language == 'hi' ? $date->hindi_category : $date->category ?>
                        </a>
                      </h6>
                      <h4>
                        <a href="<?= base_url('news-and-event-details/' . $date->slug) ?>">
                          <?= mb_strimwidth($language == 'hi' ? $date->hindi_title : $date->title, 0, 40, '...') ?>

                        </a>
                      </h4>
                      <div class="date-link">
                        <h6>
                          <span class="my-icon icon-clock"></span>
                          <?= date('d M Y', strtotime($date->date ?? date('Y-m-d'))) ?>
                        </h6>
                        <a class="link-btn" href="<?= base_url('news-and-event-details/' . $date->slug) ?>"><span
                            class="my-icon icon-arrow-right"></span></a>
                      </div>
                      <button class="left-btn"><span class="my-icon icon-angle-right"></button>
                    </div>
                  </div>
                </div>
              <?php endforeach; ?>
            </div>
            <div class="more-link text-center mt-3">
              <a class="link-anime v1"
                href="<?= base_url('news-and-event') ?>"><?= $language == 'hi' ? 'अधिक न्यूज़ और आयोजन' : 'More News And Event' ?></a>
            </div>
          </div>
        </section>
      <?php endif; ?>
      <!--  News End -->
    </main>
    <?php include_once('common_page/footer.php'); ?>

    <?php if (!empty($active_campaigns)): ?>
      <div class="overlay" id="cookiePopup" style="display: none;">
        <div class="cookie-box">
          <span class="close-btn" onclick="closePopup()">&times;</span>
          <h3>
            <?= $language == 'hi' ? $active_campaigns[0]->hindi_title : ($active_campaigns[0]->title ?? 'Campaign Active') ?>
          </h3>
          <p>
            <?= $language == 'hi' ? $active_campaigns[0]->hindi_description : ($active_campaigns[0]->description ?? 'Our latest campaign is now live!') ?>
          </p>
        </div>
      </div>

      <script>
        function closePopup() {
          document.getElementById("cookiePopup").style.display = "none";
        }

        window.onload = function () {
          setTimeout(function () {
            document.getElementById("cookiePopup").style.display = "flex";
          }, 3000);
        };
      </script>
    <?php endif; ?>

  </div>
  <?php include_once('common_page/script.php'); ?>

  <script>
    $(document).ready(function () {
      // Observer create karo
      let observer = new IntersectionObserver(function (entries, observer) {
        entries.forEach(entry => {
          if (entry.isIntersecting) {
            // Jab section visible ho tab counter start
            fetchCounters();
            observer.unobserve(entry.target); // Sirf ek baar chale
          }
        });
      }, { threshold: 0.3 }); // 30% visible hone par trigger kare

      // Counter section observe karo
      observer.observe(document.querySelector('#counter-section')); // 👈 ID apne section ki
    });

    function fetchCounters() {
      $.ajax({
        url: "<?= base_url('home/fetch_counter_data') ?>",
        type: "GET",
        dataType: "json",
        success: function (data) {
          animateCounter('#total_district', data.total_district);
          animateCounter('#total_village', data.total_village);
          animateCounter('#team_member', data.team_member);
          animateCounter('#female_member', data.females_members);
          animateCounter('#milk_qty', data.milk_qty);
        },
        error: function (xhr) {
          console.log("Error:", xhr.responseText);
        }
      });
    }

    function animateCounter(selector, target) {
      let $el = $(selector);
      $({ countNum: parseInt($el.text()) }).animate(
        { countNum: target },
        {
          duration: 2000,
          easing: 'linear',
          step: function () {
            $el.text(Math.floor(this.countNum));
          },
          complete: function () {
            $el.text(this.countNum);
          }
        }
      );
    }
  </script>

  <script>
    $(document).ready(function () {
      var owl = $(".team-carousel");

      owl.owlCarousel({
        loop: true,
        margin: 30,
        nav: true,
        dots: false,
        autoplay: true,
        autoplayTimeout: 3000,
        smartSpeed: 800,
        responsive: {
          0: { items: 1 },
          576: { items: 2 },
          768: { items: 3 },
          992: { items: 4 },
        },
        onInitialized: function () {
          fixOwlNav();
        },
        onTranslated: function () {
          fixOwlNav();
        },
      });

      function fixOwlNav() {
        // ✅ Forcefully enable nav and dots every time
        $(".owl-nav").removeClass("disabled").css("display", "flex");
        $(".owl-dots").removeClass("disabled").css("display", "block");
      }
    });
  </script>
</body>

</html>