<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="keywords" content="Maalav Milk - Maalav Milk home page" />
    <meta name="description" content="Maalav Milk - Maalav Milk home page" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

    <title><?= $language == 'hi' ? 'मेम्बरशिप एलिजिबिलिटी | मालव दूध' : 'Membership Eligibility | Maalav Milk' ?>
    </title>
    <?php include_once('common_page/links.php'); ?>
</head>

<body>


    <div id="main-wrapper">
        <?php include_once('common_page/header.php'); ?>
        <main>
            <!-- Breadcum Start -->
            <section class="breadcum v1 bg-cover-center" data-background="assets/img/breadcum/bg.jpg">
                <div class="container">
                    <h2><?= $language == 'hi' ? 'मेम्बरशिप एलिजिबिलिटी' : 'Membership Eligibility' ?></h2>
                    <ul>
                        <li><a href="<?= base_url() ?>"><?= $language == 'hi' ? 'होम' : 'Home' ?></a></li>
                        <li><?= $language == 'hi' ? 'मेम्बरशिप एलिजिबिलिटी' : 'Membership Eligibility' ?></li>
                    </ul>
                </div>
            </section>
            <!-- Breadcum End -->

            <section class="our-services v2">
                <div class="container">
                    <?php foreach ($membership as $data): ?>
                        <div class="row mb-5">
                            <div class="col-lg-6 col-xl-5 order-lg-1">
                                <div class="right-content">
                                    <div class="check-our-profile">
                                        <img src="<?= base_url($data->featured_image_one) ?>" alt="profile-img">
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6 col-xl-7">
                                <div class="content-left">
                                    <div class="section-title v1">
                                        <h6><?= $language == 'hi' ? 'मेम्बरशिप एलिजिबिलिटी' : 'Membership Eligibility' ?>
                                        </h6>
                                        <h3><?= $language == 'hi' ? $data->hindi_title_one : $data->title_one ?></h3>
                                    </div>
                                    <div>
                                        <?= $language == 'hi' ? $data->hindi_content_one : $data->content_one ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row mb-5">
                            <div class="col-lg-6 col-xl-5">
                                <div class="right-content">
                                    <div class="check-our-profile">
                                        <img src="<?= base_url($data->featured_image_two) ?>" alt="profile-img">
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6 col-xl-7">
                                <div class="content-left">
                                    <div class="section-title v1">

                                        <h3><?= $language == 'hi' ? $data->hindi_title_two : $data->title_two ?></h3>
                                    </div>
                                    <div>
                                        <?= $language == 'hi' ? $data->hindi_content_two : $data->content_two ?>
                                    </div>
                                    <div>
                                        <a href="<?= base_url($data->pdf) ?>" class="btn btn-success text-white rounded-3"
                                            download>Download Brochure</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach ?>
                </div>
            </section>
        </main>

        <?php include_once('common_page/footer.php'); ?>
    </div>
    <?php include_once('common_page/script.php'); ?>
</body>

</html>