<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="keywords" content="Maalav Milk - Maalav Milk home page" />
    <meta name="description" content="Maalav Milk - Maalav Milk home page" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

    <title>
        <?= $language == 'hi' ? 'हमारा विशेष कार्य, हमारा नज़रिया, हमारे मूल्य | मालव दूध' : 'Mission, Vision, Value | Maalav Milk' ?>
    </title>
    <?php include_once('common_page/links.php'); ?>
</head>

<body>
    <div id="main-wrapper">
        <?php include_once('common_page/header.php'); ?>
        <main>
            <!-- Breadcum Start -->
            <section class="breadcum v1 bg-cover-center" data-background="<?= base_url() ?>assets/img/breadcum/bg.jpg">
                <div class="container">
                    <h2> <?= $language == 'hi' ? 'हमारा विशेष कार्य, हमारा नज़रिया, हमारे मूल्य' : 'Mission, Vision, Value' ?>
                    </h2>
                    <ul>
                        <li><a href="<?= base_url() ?>"><?= $language == 'hi' ? 'होम' : 'Home' ?></a></li>
                        <li><?= $language == 'hi' ? 'हमारा विशेष कार्य, हमारा नज़रिया, हमारे मूल्य' : 'Mission, Vision, Value' ?>
                        </li>
                    </ul>
                </div>
            </section>
            <!-- Breadcum End -->
            <!-- Team Start -->
            <section class="our-services v1" id="value-mission-vision">
                <div class="container my-5">

                    <h2 class="text-center mb-5 fw-bold">
                        <?= $language == 'hi' ? 'हमारे मूल्य, हमारा विशेष कार्य, हमारे मूल्य' : 'Values, Mission and Vision' ?>
                    </h2>

                    <div class="row g-4 align-items-stretch">

                        <!-- IMAGE LEFT -->
                        <div class="col-md-4">
                            <div>
                                <img src="<?= base_url('assets/img/mission1.jpeg') ?>"
                                    class="img-fluid rounded-4 w-100 h-80 object-fit-cover" alt="">
                            </div>

                            <div class="mt-2">
                                <div class="p-4 bg-light rounded-4 text-center shadow-sm d-flex flex-column h-100">
                                    <div class="mb-3">
                                        <img src="<?= base_url('assets/img/vision.png') ?>" width="80">
                                    </div>
                                    <h4 class="fw-bold mb-3">
                                        <?= $language == 'hi' ? 'हमारे मूल्य' : 'Our Values' ?>
                                    </h4>
                                    <p class="flex-grow-1">
                                        <?= $language == 'hi' ? 'कंपनी का हित सर्वोपरि<br>दूरदर्शिता<br>ईमानदारी<br>पारदर्शिता <br>गुणवत्ता<br>जिम्मेदारी<br>टीम भावना' : 'Company’s interest is paramount<br>Foresightedness<br>Honesty <br>Transparency<br>Quality  <br>Responsibility  <br>Team Spirit' ?>

                                    </p>
                                </div>
                            </div>
                        </div>

                        <!-- VALUES -->
                        <div class="col-md-4">
                            <div class="p-4 bg-light rounded-4 text-center shadow-sm d-flex flex-column">
                                <div class="mb-3">
                                    <img src="<?= base_url('assets/img/value.png') ?>" width="80">
                                </div>
                                <h4 class="fw-bold mb-3">
                                    <?= $language == 'hi' ? 'हमारा विशेष कार्य' : 'Our Mission' ?>
                                    
                                          <p class="flex-grow-1">
                                    <?= $language == 'hi' ? 'मालव महिला दूध उत्पादक कंपनी अपने सभी सदस्यों से प्रतिस्पर्धी मूल्य पर गुणवत्तापूर्ण दूध एकत्र करेगी, और दूध उत्पादन बढ़ाने, लागत खर्चों को कम करने के लिए तकनीकी सेवा प्रदान करके दूध व्यवसाय से अर्जित उनके लाभ को बढ़ाने के लिए दृढ़ संकल्पित है। ' : 'Malav Mahila Milk Producer Company will be one of the five best companies in Central India and will be the first choice of milk producers, consumers, and employees.' ?>

                                </h4>
                               
                                 <div class="mt-5">
                                    <a href="<?= base_url() ?>" class="btn btn-primary text-white fw-bold">HOME</a>
                                </div>
                            </div>
                        </div>

                        <!-- VISION -->
                        <div class="col-md-4">
                            <div class="p-4 bg-light rounded-4 text-center shadow-sm d-flex flex-column">
                                <div class="mb-3">
                                    <img src="<?= base_url('assets/img/mission.png') ?>" width="80">
                                </div>
                                <h4 class="fw-bold mb-3">
                                    <?= $language == 'hi' ? 'हमारा नज़रिया': 'Our Vision' ?>

                                </h4>
                                <p class="flex-grow-1">
                                    <?= $language == 'hi' ? 'मालव महिला दूध उत्पादक कंपनी मध्य भारत की पांच सर्वश्रेष्ठ कंपनियों में से एक होगी और दूध उत्पादकों, उपभोक्ताओं और कर्मचारियों की पहली पसंद होगी। ' : 'Malav Mahila Milk Producer Company will be one of the five best companies in Central India and will be the first choice of milk producers, consumers, and employees.' ?>

                                </p>
                            </div>
                            <div class="mt-2">
                                <img src="<?= base_url('assets/img/mission2.jpeg') ?>"
                                    class="img-fluid rounded-4 w-100 h-100 object-fit-cover" alt="">
                            </div>
                        </div>

                        <!-- VISION -->


                        <!-- IMAGE RIGHT -->


                    </div>
                </div>
            </section>
        </main>
        <?php include_once('common_page/footer.php'); ?>
    </div>
    <?php include_once('common_page/script.php'); ?>
</body>

</html>