<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="keywords" content="Maalav Milk - Maalav Milk blog page" />
    <meta name="description" content="Maalav Milk - Maalav Milk blog page" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

    <title>
        <?= $language == 'hi' ? 'न्यूज़ और आयोजन | मालव दूध' : ' News & Event | Maalav Milk' ?>

    </title>
    <?php include_once('common_page/links.php'); ?>
</head>

<body>


    <div id="main-wrapper">
        <?php include_once('common_page/header.php'); ?>
        <main>
            <!-- Breadcum Start -->
            <section class="breadcum v1 bg-cover-center" data-background="<?= base_url() ?>assets/img/breadcum/bg.jpg">
                <div class="container">
                    <h2><?= $language == 'hi' ? 'न्यूज़ और आयोजन' : 'News & Event' ?></h2>
                    <ul>
                        <li><a href="<?= base_url() ?>"><?= $language == 'hi' ? 'होम' : 'Home' ?></a></li>
                        <li><?= $language == 'hi' ? 'न्यूज़ और आयोजन' : 'News & Event' ?></li>
                    </ul>
                </div>
            </section>
            <!-- Breadcum End -->
            <!-- Blog Start -->
            <section class="blog v1 pb-xl-spach">
                <div class="container">
                    <div class="row">
                        <?php if ($news): ?>
                            <?php foreach ($news as $data): ?>
                                <div class="col-lg-3">

                                    <div class="big-post">
                                        <div class="post-img">
                                            <a href="<?= base_url('news-and-event-details/' . $data->slug) ?>">
                                                <img src="<?= base_url($data->featured_image) ?>" alt="post">
                                            </a>
                                        </div>
                                        <div class="post-content">
                                            <ul>

                                                <li>
                                                    <h6>
                                                        <span class="my-icon icon-clock"></span>
                                                        <?= date('d M Y', strtotime($data->date ?? date('Y-m-d'))) ?>
                                                    </h6>
                                                </li>

                                            </ul>
                                            <h3>
                                                <a href="<?= base_url('news-and-event-details/' . $data->slug) ?>">
                                                    <?= mb_strimwidth($language == 'hi' ? $data->hindi_title : $data->title, 0, 40, '...') ?>

                                                </a>
                                            </h3>

                                            <a class="post-link"
                                                href="<?= base_url('news-and-event-details/' . $data->slug) ?>"><?= $language == 'hi' ? 'और पढ़ें' : 'read more' ?></a>
                                        </div>
                                    </div>


                                </div>
                            <?php endforeach ?>
                        <?php else: ?>
                            <p>No news found.</p>
                        <?php endif; ?>

                    </div>
                </div>
            </section>
            <!-- Blog End -->
        </main>
        <?php include_once('common_page/footer.php'); ?>
    </div>
    <?php include_once('common_page/script.php'); ?>
</body>

</html>