<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="keywords" content="Maalav Milk - Privacy Policy" />
    <meta name="description" content="Maalav Milk Privacy Policy" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

    <title><?= $language == 'hi' ? 'गोपनीयता नीति | मालव दूध' : 'Privacy Policy | Maalav Milk' ?></title>

    <?php include_once('common_page/links.php'); ?>

    <style>
        .hero {
            background: linear-gradient(90deg, #e6f0ff, #ffffff);
            border-radius: 0.5rem;
        }

        .toc a {
            text-decoration: none;
        }

        .section {
            padding-top: 1.25rem;
            padding-bottom: 1.25rem;
        }

        .small-muted {
            font-size: 0.9rem;
            color: #6c757d;
        }

        section[id] {
            scroll-margin-top: 7rem;
        }

        .sticky-top {
            z-index: 1;
        }

        @media (max-width: 991px) {
            .sticky-top {
                position: static !important;
                top: auto !important;
            }
        }
    </style>
</head>

<body>
    <div id="main-wrapper">
        <?php include_once('common_page/header.php'); ?>

        <main>
            <!-- Breadcrumb Start -->
            <section class="breadcum v1 bg-cover-center" data-background="assets/img/breadcum/bg.jpg">
                <div class="container">
                    <h2><?= $language == 'hi' ? 'गोपनीयता नीति' : 'Privacy Policy' ?></h2>
                    <ul>
                        <li><a href="<?= base_url() ?>"><?= $language == 'hi' ? 'होम' : 'Home' ?></a></li>
                        <li><?= $language == 'hi' ? 'गोपनीयता नीति' : 'Privacy Policy' ?></li>
                    </ul>
                </div>
            </section>
            <!-- Breadcrumb End -->

            <section class="container my-5 mb-5">
                <div class="row">
                    <!-- Sidebar / Table of Contents -->
                    <aside class="col-lg-4 mb-4">
                        <div class="card sticky-top" style="top: 7rem;">
                            <div class="card-body">
                                <h5 class="card-title mb-3"><?= $language == 'hi' ? 'सामग्री' : 'Contents' ?></h5>
                                <nav class="toc">
                                    <ul class="list-unstyled">
                                        <li><a
                                                href="#introduction"><?= $language == 'hi' ? 'परिचय' : 'Introduction' ?></a>
                                        </li>
                                        <li><a
                                                href="#information"><?= $language == 'hi' ? 'जानकारी का संग्रह' : 'Information We Collect' ?></a>
                                        </li>
                                        <li><a
                                                href="#use"><?= $language == 'hi' ? 'जानकारी का उपयोग' : 'How We Use Information' ?></a>
                                        </li>
                                        <li><a
                                                href="#sharing"><?= $language == 'hi' ? 'जानकारी साझा करना' : 'Information Sharing' ?></a>
                                        </li>
                                        <li><a href="#security"><?= $language == 'hi' ? 'सुरक्षा' : 'Security' ?></a>
                                        </li>
                                        <li><a href="#cookies"><?= $language == 'hi' ? 'कुकीज' : 'Cookies' ?></a></li>
                                        <li><a
                                                href="#changes"><?= $language == 'hi' ? 'नीति में बदलाव' : 'Changes to Policy' ?></a>
                                        </li>
                                        <li><a href="#contact"><?= $language == 'hi' ? 'संपर्क करें' : 'Contact' ?></a>
                                        </li>
                                    </ul>
                                </nav>
                            </div>
                        </div>
                    </aside>

                    <!-- Main Article -->
                    <article class="col-lg-8">

                        <section id="introduction" class="section bg-white p-4 rounded shadow-sm mb-3">
                            <h2>1. <?= $language == 'hi' ? 'परिचय' : 'Introduction' ?></h2>
                            <p>
                                <?= $language == 'hi' ? 'मालव दूध ("हम", "हमारा") आपकी गोपनीयता की सुरक्षा के लिए प्रतिबद्ध है। यह नीति बताती है कि हम आपकी व्यक्तिगत जानकारी को कैसे एकत्रित, उपयोग और संरक्षित करते हैं।' : 'Maalav Milk ("we", "our") is committed to protecting your privacy. This policy explains how we collect, use, and safeguard your personal information.' ?>
                            </p>
                        </section>

                        <section id="information" class="section bg-white p-4 rounded shadow-sm mb-3">
                            <h2>2. <?= $language == 'hi' ? 'जानकारी का संग्रह' : 'Information We Collect' ?></h2>
                            <ul>
                                <li><?= $language == 'hi' ? 'व्यक्तिगत जानकारी जैसे नाम, ईमेल, फ़ोन नंबर।' : 'Personal information such as name, email, phone number.' ?>
                                </li>
                                <li><?= $language == 'hi' ? 'ऑर्डर और भुगतान संबंधी जानकारी।' : 'Order and payment information.' ?>
                                </li>
                                <li><?= $language == 'hi' ? 'वेबसाइट उपयोग और ब्राउज़र डेटा।' : 'Website usage and browser data.' ?>
                                </li>
                            </ul>
                        </section>

                        <section id="use" class="section bg-white p-4 rounded shadow-sm mb-3">
                            <h2>3. <?= $language == 'hi' ? 'जानकारी का उपयोग' : 'How We Use Information' ?></h2>
                            <ul>
                                <li><?= $language == 'hi' ? 'आपके ऑर्डर की प्रोसेसिंग और डिलीवरी।' : 'To process and deliver your orders.' ?>
                                </li>
                                <li><?= $language == 'hi' ? 'आपसे संपर्क करना और ग्राहक सहायता प्रदान करना।' : 'To communicate with you and provide customer support.' ?>
                                </li>
                                <li><?= $language == 'hi' ? 'वेबसाइट सुधार और सेवाओं का विश्लेषण।' : 'To improve our website and services.' ?>
                                </li>
                            </ul>
                        </section>

                        <section id="sharing" class="section bg-white p-4 rounded shadow-sm mb-3">
                            <h2>4. <?= $language == 'hi' ? 'जानकारी साझा करना' : 'Information Sharing' ?></h2>
                            <p>
                                <?= $language == 'hi' ? 'हम आपकी व्यक्तिगत जानकारी किसी तृतीय पक्ष के साथ बिना अनुमति साझा नहीं करते, सिवाय जहां कानूनी रूप से आवश्यक हो।' : 'We do not share your personal information with third parties without consent, except as required by law.' ?>
                            </p>
                        </section>

                        <section id="security" class="section bg-white p-4 rounded shadow-sm mb-3">
                            <h2>5. <?= $language == 'hi' ? 'सुरक्षा' : 'Security' ?></h2>
                            <p>
                                <?= $language == 'hi' ? 'हम आपकी जानकारी की सुरक्षा के लिए उपयुक्त तकनीकी और संगठनात्मक उपाय अपनाते हैं।' : 'We implement appropriate technical and organizational measures to protect your information.' ?>
                            </p>
                        </section>

                        <section id="cookies" class="section bg-white p-4 rounded shadow-sm mb-3">
                            <h2>6. <?= $language == 'hi' ? 'कुकीज' : 'Cookies' ?></h2>
                            <p>
                                <?= $language == 'hi' ? 'हमारी वेबसाइट कुकीज का उपयोग कर सकती है ताकि उपयोग अनुभव को बेहतर बनाया जा सके और विश्लेषण किया जा सके।' : 'Our website may use cookies to enhance user experience and for analytics purposes.' ?>
                            </p>
                        </section>

                        <section id="changes" class="section bg-white p-4 rounded shadow-sm mb-3">
                            <h2>7. <?= $language == 'hi' ? 'नीति में बदलाव' : 'Changes to Policy' ?></h2>
                            <p>
                                <?= $language == 'hi' ? 'हम इस गोपनीयता नीति को किसी भी समय अपडेट कर सकते हैं। अपडेटेड नीति इस पेज पर प्रकाशित की जाएगी।' : 'We may update this privacy policy at any time. Updated policies will be posted on this page.' ?>
                            </p>
                        </section>

                        <section id="contact" class="section bg-white p-4 rounded shadow-sm mb-3">
                            <h2>8. <?= $language == 'hi' ? 'संपर्क करें' : 'Contact Us' ?></h2>
                            <p>
                                <?= $language == 'hi' ? 'यदि आपके पास इस गोपनीयता नीति के बारे में कोई प्रश्न हैं, तो कृपया हमसे संपर्क करें:' : 'If you have any questions regarding this Privacy Policy, please contact us:' ?>
                            </p>
                            <p class="mb-0"><strong>Email:</strong> <a
                                    href="mailto:support@maalavmilk.com">support@maalavmilk.com</a></p>
                            <p class="mb-0"><strong>Website:</strong> <a href="https://www.maalavmilk.com/"
                                    target="_blank">www.maalavmilk.com</a></p>
                            <p class="mb-0"><strong>Address:</strong> Maalav Milk Pvt. Ltd., India</p>
                        </section>

                    </article>
                </div>
            </section>
        </main>

        <?php include_once('common_page/footer.php'); ?>
    </div>

    <?php include_once('common_page/script.php'); ?>

    <script>
        // Smooth scroll for table of contents
        document.querySelectorAll(".toc a").forEach((a) => {
            a.addEventListener("click", function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute("href"));
                if (target) target.scrollIntoView({ behavior: "smooth", block: "start" });
            });
        });
    </script>
</body>

</html>