<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="keywords" content="Maalav Milk - Maalav Milk home page" />
    <meta name="description" content="Maalav Milk - Maalav Milk home page" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

    <title>
        <?= $language == 'hi' ? 'टीम मेंबर्स | मालव दूध' : 'Team Members | Maalav Milk' ?>

    </title>
    <?php include_once('common_page/links.php'); ?>
    <style>
        .profile-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
            padding: 60px;
            max-width: 1200px;
            width: 100%;
            margin-bottom: 10rem;
            margin-top: 2rem;
        }

        .profile-image-container {
            position: relative;
        }

        .profile-image {
            width: 300px;
            height: 300px;
            border-radius: 50%;
            object-fit: cover;
            border: 8px solid white;
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.15);
        }

        .profile-content h1 {
            font-size: 3rem;
            font-weight: 800;
            color: #212529;
            margin-bottom: 15px;
        }

        .profile-title {
            font-size: 1.8rem;
            font-weight: 600;
            color: #c2488a;
            margin-bottom: 30px;
        }

        .profile-description {
            font-size: 1.1rem;
            line-height: 1.8;
            color: #4a4a4a;
            text-align: justify;
            margin-bottom: 35px;
        }

        .back-btn {
            background: linear-gradient(135deg, #c2488a 0%, #a8397a 100%);
            color: white;
            border: none;
            padding: 15px 50px;
            font-size: 1.2rem;
            font-weight: 600;
            border-radius: 50px;
            cursor: pointer;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(194, 72, 138, 0.3);
        }

        .back-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(194, 72, 138, 0.4);
            background: linear-gradient(135deg, #a8397a 0%, #8e2f68 100%);
        }

        @media (max-width: 768px) {
            .profile-card {
                padding: 30px;
            }

            .profile-image {
                width: 200px;
                height: 200px;
                margin: 0 auto 30px;
                display: block;
            }

            .profile-content h1 {
                font-size: 2rem;
                text-align: center;
            }

            .profile-title {
                font-size: 1.3rem;
                text-align: center;
            }

            .profile-description {
                font-size: 1rem;
            }

            .back-btn {
                width: 100%;
            }
        }
    </style>
</head>

<body>
    <div id="main-wrapper">
        <?php include_once('common_page/header.php'); ?>
        <main>
            <!-- Breadcum Start -->
            <section class="breadcum v1 bg-cover-center" data-background="<?= base_url() ?>assets/img/breadcum/bg.jpg">
                <div class="container">
                    <h2> <?= $language == 'hi' ? 'टीम मेंबर्स' : 'Team Members' ?></h2>
                    <ul>
                        <li><a href="<?= base_url() ?>"><?= $language == 'hi' ? 'होम' : 'Home' ?></a></li>
                        <li><?= $language == 'hi' ? 'टीम मेंबर्स' : 'Team Members' ?></li>
                    </ul>
                </div>
            </section>
            <!-- Breadcum End -->
            <section class="row justify-content-center">
                <div class="profile-card ">
                    <div class="row align-items-center">
                        <div class="col-lg-4 col-md-12 text-center mb-4 mb-lg-0">
                            <div class="profile-image-container">
                                <img src="<?= base_url($team->featured_image) ?>" alt="<?= $team->name ?>"
                                    class="profile-image" />
                            </div>
                        </div>
                        <div class="col-lg-8 col-md-12">
                            <div class="profile-content">
                                <h1><?= $language == 'hi' ? $team->hindi_name : $team->name ?></h1>
                                <div class="profile-title">
                                    <?= $language == 'hi' ? $team->hindi_designation : $team->designation ?>
                                </div>
                                <p class="profile-description">
                                    <?= $language == 'hi' ? $team->hindi_content : $team->content ?>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

        </main>
        <?php include_once('common_page/footer.php'); ?>
    </div>
    <?php include_once('common_page/script.php'); ?>
</body>

</html>