<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="keywords" content="Maalav Milk - Maalav Milk home page" />
    <meta name="description" content="Maalav Milk - Maalav Milk home page" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

    <title>
        <?= $language == 'hi' ? 'वीडियो गैलरी | मालव दूध' : 'Video Gallery | Maalav Milk' ?>

    </title>
    <?php include_once('common_page/links.php'); ?>
</head>

<body>


    <div id="main-wrapper">
        <?php include_once('common_page/header.php'); ?>
        <main>
            <!-- Breadcum Start -->
            <section class="breadcum v1 bg-cover-center" data-background="assets/img/breadcum/bg.jpg">
                <div class="container">
                    <h2> <?= $language == 'hi' ? 'वीडियो गैलरी' : 'Video Gallery' ?></h2>
                    <ul>
                        <li><a href="<?= base_url() ?>"><?= $language == 'hi' ? 'होम' : 'Home' ?></a></li>
                        <li><?= $language == 'hi' ? 'वीडियो गैलरी' : 'Video Gallery' ?></li>
                    </ul>
                </div>
            </section>
            <!-- Breadcum End -->

            <section class="gallery-display v1 pb-xl-spach">
                <div class="container">

                    <div class="row gallery-items">
                        <?php foreach ($gallery as $data): ?>
                            <?php
                            // Convert watch URL to embed URL
                            $videoUrl = $data->video_link;

                            if (strpos($videoUrl, 'watch?v=') !== false) {
                                $videoId = explode('watch?v=', $videoUrl)[1];
                                $videoUrl = 'https://www.youtube.com/embed/' . $videoId;
                            }
                            ?>
                            <div class="col-md-4">
                                <div class="video-box position-relative text-center">
                                    <div class="ratio ratio-16x9">
                                        <iframe
                                            src="<?= $videoUrl ?>?rel=0"
                                            title="Video"
                                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                                            allowfullscreen>
                                        </iframe>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>

                    </div>

                </div>
            </section>
        </main>
        <?php include_once('common_page/footer.php'); ?>
    </div>
    <?php include_once('common_page/script.php'); ?>
</body>

</html>