/*
Template Name: Property Finder - Admin & Dashboard Template
Author: Pixeleyez
Website: https://pixeleyez.com/
File: Remix Icons init js
*/

const icons = [
  "ri-home-7-line",
  "ri-mail-open-line",
  "ri-markup-line",
  "ri-code-line",
  "ri-cloud-line",
  "ri-paint-brush-line",
  "ri-bold",
  "ri-italic",
  "ri-underline",
  "ri-arrow-up-circle-line",
  "ri-arrow-down-circle-line",
  "ri-arrow-left-circle-line",
  "ri-arrow-right-circle-line",
  "ri-checkbox-line",
  "ri-check-line",
  "ri-close-line",
  "ri-database-2-line",
  "ri-delete-bin-5-line",
  "ri-eye-line",
  "ri-eye-off-line",
  "ri-folder-2-line",
  "ri-heart-line",
  "ri-information-line",
  "ri-key-line",
  "ri-lock-line",
  "ri-lock-unlock-line",
  "ri-map-pin-line",
  "ri-message-2-line",
  "ri-notification-4-line",
  "ri-pencil-line",
  "ri-phone-line",
  "ri-play-line",
  "ri-refresh-line",
  "ri-settings-3-line",
  "ri-share-line",
  "ri-star-line",
  "ri-sun-line",
  "ri-swap-line",
  "ri-thumb-up-line",
  "ri-upload-line",
  "ri-user-line",
  "ri-video-line",
  "ri-volume-up-line",
  "ri-wallet-line",
  "ri-weather-sunny-line",
  "ri-screenshot-2-line",
  "ri-draft-line",
  "ri-save-line",
  "ri-repeat-line",
  "ri-rocket-line",
  "ri-scan-line",
  "ri-file-3-line",
  "ri-folder-line",
  "ri-calendar-line",
  "ri-bar-chart-line",
  "ri-bookmark-line",
  "ri-reddit-line",
  "ri-telegram-line",
  "ri-twitter-line",
  "ri-facebook-line",
  // Adding more icons
  "ri-add-circle-line",
  "ri-alert-line",
  "ri-archive-line",
  "ri-arrow-up-line",
  "ri-arrow-down-line",
  "ri-arrow-left-line",
  "ri-arrow-right-line",
  "ri-attachment-line",
  "ri-basketball-line",
  "ri-bell-line",
  "ri-book-line",
  "ri-car-line",
  "ri-chart-bar-line",
  "ri-chat-1-line",
  "ri-chat-2-line",
  "ri-check-double-line",
  "ri-clipboard-line",
  "ri-cloud-fill",
  "ri-cup-line",
  "ri-earth-line",
  "ri-equalizer-line",
  "ri-file-download-line",
  "ri-file-text-line",
  "ri-file-upload-line",
  "ri-flashlight-line",
  "ri-folder-3-line",
  "ri-globe-line",
  "ri-heart-fill",
  "ri-home-fill",
  "ri-hourglass-line",
  "ri-image-line",
  "ri-keyboard-line",
  "ri-laptop-line",
  "ri-layout-4-line",
  "ri-lightbulb-line",
  "ri-map-line",
  "ri-mic-line",
  "ri-pencil-ruler-line",
  "ri-phone-fill",
  "ri-play-circle-line",
  "ri-pulse-line",
  "ri-radio-line",
  "ri-refresh-line",
  "ri-rocket-2-line",
  "ri-search-line",
  "ri-shield-check-line",
  "ri-shield-line",
  "ri-signal-tower-line",
  "ri-snapchat-line",
  "ri-star-fill",
  "ri-timer-line",
  "ri-tools-line",
  "ri-trophy-line",
  "ri-tv-line",
  "ri-upload-cloud-line",
  "ri-user-fill",
  "ri-volume-mute-line",
  "ri-wifi-line",
  "ri-youtube-line",
  "ri-umbrella-line",
  "ri-briefcase-line",
  "ri-calendar-check-line",
  "ri-camera-line",
  "ri-cash-line",
  "ri-dashboard-line",
  "ri-database-line",
  "ri-flag-line",
  "ri-folder-open-line",
  "ri-game-line",
  "ri-gift-line",
  "ri-glasses-line",
  "ri-hammer-line",
  "ri-headphone-line",
  "ri-history-line",
  "ri-image-2-line",
  "ri-inbox-line",
  "ri-lock-2-line",
  "ri-magic-line",
  "ri-map-2-line",
  "ri-mic-2-line",
  "ri-music-line",
  "ri-paint-line",
  "ri-pencil-ruler-2-line",
  "ri-pie-chart-line",
  "ri-receipt-line",
  "ri-rewind-line",
  "ri-share-box-line",
  "ri-shield-user-line",
  "ri-shopping-bag-line",
  "ri-shopping-cart-line",
  "ri-slice-line",
  "ri-snowflake-line",
  "ri-swap-2-line",
  "ri-table-line",
  "ri-trophy-fill",
  "ri-battery-line",
  "ri-camera-2-line",
  "ri-crop-line",
  "ri-filter-line",
  "ri-folder-check-line",
  "ri-folder-5-line",
  "ri-hospital-line",
  "ri-key-2-line",
  "ri-menu-2-line",
  "ri-message-3-line",
  "ri-pie-chart-2-line",
  "ri-question-line",
  "ri-shopping-cart-2-line",
  "ri-truck-line",
  "ri-tv-2-line",
  "ri-user-2-line",
  "ri-wallet-2-line",
  "ri-zoom-in-line",
  "ri-zoom-out-line",
  "ri-album-line",
  "ri-apps-line",
  "ri-archive-2-line",
  "ri-arrow-left-right-line",
  "ri-arrow-up-down-line",
  "ri-battery-2-line",
  "ri-bug-line",
  "ri-cast-line",
  "ri-chat-new-line",
  "ri-clapperboard-line",
  "ri-cloud-off-line",
  "ri-film-line",
  "ri-fire-line",
  "ri-flag-2-line",
  "ri-flower-line",
  "ri-football-line",
  "ri-hourglass-2-line",
  "ri-leaf-line",
  "ri-notification-2-line",
  "ri-pantone-line",
  "ri-plug-line",
  "ri-skull-line",
  "ri-tent-line",
  "ri-voiceprint-line",
];

const iconList = document.getElementById("iconList");
const searchInput = document.getElementById("iconSearch");
const copyAlert = document.getElementById("copyAlert");
const copiedText = document.getElementById("copiedText");

// Function to display icons
function displayIcons(filter = "") {
  iconList.innerHTML = ""; // Clear existing icons
  const filteredIcons = icons.filter((icon) =>
    icon.toLowerCase().includes(filter.toLowerCase())
  );

  filteredIcons.forEach((icon) => {
    const iconBox = document.createElement("div");
    iconBox.className = "icon-box";
    iconBox.innerHTML = `<i class="${icon}"></i><strong>${icon}</strong>`;

    // Add click event to copy the icon format
    iconBox.addEventListener("click", () => {
      const iconFormat = `<i class="${icon}"></i>`;
      navigator.clipboard
        .writeText(iconFormat)
        .then(() => {
          // Show simple text alert on successful copy
          copyAlert.textContent = "Copied!"; // Set simple text message
          copyAlert.style.display = "block"; // Show the alert
          setTimeout(() => {
            copyAlert.style.display = "none"; // Hide after 3 seconds
          }, 1300);
        })
        .catch((err) => {
          console.error("Failed to copy: ", err);
        });
    });

    iconList.appendChild(iconBox);
  });
}

// Initial display of icons
displayIcons();

// Event listener for search input
searchInput.addEventListener("input", (e) => {
  displayIcons(e.target.value);
});
