<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Contact extends MY_Controller
{
    public function index()
    {
        $this->load->view('contact');
    }

    public function save()
    {
        $this->load->library('form_validation');

        $this->form_validation->set_rules('name', 'Name', 'required|trim');
        $this->form_validation->set_rules('email', 'Email', 'required|valid_email');
        $this->form_validation->set_rules('phone', 'Phone', 'required|trim');
        $this->form_validation->set_rules('subject', 'Subject', 'required|trim');
        $this->form_validation->set_rules('message', 'Message', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            echo json_encode([
                'status' => 'error',
                'errors' => [
                    'name' => form_error('name'),
                    'email' => form_error('email'),
                    'phone' => form_error('phone'),
                    'subject' => form_error('subject'),
                    'message' => form_error('message')
                ]
            ]);
            return;
        }

        $data = [
            'name' => $this->input->post('name'),
            'email' => $this->input->post('email'),
            'phone' => $this->input->post('phone'),
            'subject' => $this->input->post('subject'),
            'message' => $this->input->post('message'),
            'date' => date('Y-m-d')
        ];

        $this->load->model('Contact_model');
        $this->Contact_model->contact($data);

        echo json_encode([
            'status' => 'success',
            'message' => 'Thank you! Your message has been submitted.'
        ]);
    }

}