<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Student_form extends MY_Controller
{
    public function index()
    {
        $this->load->model('Course_model');
        $data['courses'] = $this->Course_model->get_all();
        $this->load->view('register', $data);
    }




    public function submit_application()
    {
        $this->load->model('Application_model');
        $this->load->library('upload');

        // Check if UG checkbox is ticked
        $has_ug = $this->input->post('has_ug');

        // Required files list (jo form mein * mark hai)
        $required_files = ['marksheet', 'passport_photo', 'esign'];
        if ($has_ug) {
            $required_files[] = 'ug_marksheet';
        }

        $upload_path = './uploads/students/';
        if (!is_dir($upload_path))
            mkdir($upload_path, 0777, true);

        $uploaded = [];

        // Upload all files
        foreach (['marksheet', 'passport_photo', 'esign', 'gap_certificate', 'ug_marksheet'] as $field) {
            if (empty($_FILES[$field]['name'])) {
                if (in_array($field, $required_files)) {
                    $this->session->set_flashdata('error', "Please upload " . str_replace('_', ' ', ucwords($field)));
                    redirect('student-register');
                }
                $uploaded[$field] = null;
                continue;
            }

            $config = [
                'upload_path' => $upload_path,
                'allowed_types' => 'jpg|jpeg|png|pdf',
                'max_size' => 2048,
                'file_name' => uniqid() . '_' . $_FILES[$field]['name']
            ];

            $this->upload->initialize($config);

            if (!$this->upload->do_upload($field)) {
                $error = strip_tags($this->upload->display_errors());
                $this->session->set_flashdata('error', "Upload failed: $field → $error");
                redirect('student-register');
            }

            $uploaded[$field] = 'uploads/students/' . $this->upload->data('file_name');
        }

        // Save main application
        $data = [
            'full_name' => $this->input->post('full_name'),
            'dob' => $this->input->post('dob'),
            'mobile' => $this->input->post('mobile'),
            'email' => $this->input->post('email'),
            'parent_name' => $this->input->post('parent_name'),
            'parent_mobile' => $this->input->post('parent_mobile'),
            'gender' => $this->input->post('gender'),
            'govt_id_type' => $this->input->post('govt_id_type'),
            'govt_id_number' => $this->input->post('govt_id_number'),
            'addr1' => $this->input->post('addr1'),
            'addr2' => $this->input->post('addr2'),
            'city' => $this->input->post('city'),
            'state_ut' => $this->input->post('state_ut'),
            'pin' => $this->input->post('pin'),
            'domicile' => $this->input->post('domicile'),
            'board' => $this->input->post('board'),
            'stream' => $this->input->post('stream'),
            'school_name' => $this->input->post('school_name'),
            'school_city' => $this->input->post('school_city'),
            'passing_year' => $this->input->post('passing_year'),
            'result_status' => $this->input->post('result_status'),
            'percentage' => $this->input->post('percentage'),
            'key_subjects' => $this->input->post('key_subjects'),
            'gap_year' => $this->input->post('gap_year') ?: 'No',
            'gap_explain' => $this->input->post('gap_explain'),
            'has_ug' => $has_ug ? 1 : 0,
            'ug_course' => $has_ug ? $this->input->post('ug_course') : '',
            'ug_stream' => $has_ug ? $this->input->post('ug_stream') : '',
            'ug_college' => $has_ug ? $this->input->post('ug_college') : '',
            'ug_university' => $has_ug ? $this->input->post('ug_university') : '',
            'ug_passing_year' => $has_ug ? $this->input->post('ug_passing_year') : '',
            'ug_percentage' => $has_ug ? $this->input->post('ug_percentage') : '',
            'marksheet' => $uploaded['marksheet'],
            'gap_certificate' => $uploaded['gap_certificate'],
            'ug_marksheet' => $uploaded['ug_marksheet'],
            'esign' => $uploaded['esign'],
            'passport_photo' => $uploaded['passport_photo'],
            'esign_date' => $this->input->post('esign_date'),
            'created_at' => date('Y-m-d H:i:s')
        ];

        $student_id = $this->Application_model->insert_application($data);

        if (!$student_id) {
            $this->session->set_flashdata('error', 'Database error. Please try again.');
            redirect('student-register');
        }

        // Save preferences
        $prefs = $this->input->post('preference1');
        if (is_array($prefs)) {
            foreach ($prefs as $i => $pref) {
                if (!empty(trim($pref))) {
                    $this->Application_model->save_preference([
                        'student_id' => $student_id,
                        'preference' => $pref
                    ]);
                }
            }
        }

        // Clear autosave draft
        echo "<script>localStorage.removeItem('appDraft_v1');</script>";

        $this->session->set_flashdata('success', "Application submitted successfully! Your ID: $student_id");
        redirect(base_url());
    }
}