<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Event extends CI_Controller
{


    public function index()
    {
        $this->load->model('event_model');
        $data['event'] = $this->event_model->get_all();
        $this->load->view('admin/event', $data);
    }

    public function add_event()
    {
        $this->load->view('admin/add-event');
    }
    public function submit_event()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('title', 'Title', 'required|trim');
        $this->form_validation->set_rules('hindi_title', 'Hindi Title', 'required|trim');
        $this->form_validation->set_rules('slug', 'Slug', 'required|trim');
        $this->form_validation->set_rules('hindi_slug', 'Hindi Slug', 'required|trim');
        $this->form_validation->set_rules('content', 'Content', 'required|trim');
        $this->form_validation->set_rules('hindi_content', 'Hindi Content', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'title' => form_error('title'),
                'hindi_title' => form_error('hindi_title'),
                'slug' => form_error('slug'),
                'hindi_slug' => form_error('hindi_slug'),
                'content' => form_error('content'),
                'hindi_content' => form_error('hindi_content'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        $eventData = [
            'title' => $this->input->post('title'),
            'hindi_title' => $this->input->post('hindi_title'),
            'slug' => $this->input->post('slug'),
            'hindi_slug' => $this->input->post('hindi_slug'),
            'content' => $this->input->post('content'),
            'hindi_content' => $this->input->post('hindi_content'),
        ];

        // Upload folder config
        $uploadPath = './uploads/event/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config['upload_path'] = $uploadPath;
        $config['allowed_types'] = 'jpg|jpeg|png|webp|gif|svg';
        $config['max_size'] = 5120; // 5MB
        $config['encrypt_name'] = TRUE;

        $this->load->library('upload', $config);

        if (!empty($_FILES['featured_image']['name'])) {
            if ($this->upload->do_upload('featured_image')) {
                $uploadData = $this->upload->data();
                $eventData['featured_image'] = 'uploads/event/' . $uploadData['file_name'];
            } else {
                echo json_encode([
                    'status' => 'error',
                    'errors' => ['featured_image' => $this->upload->display_errors('', '')]
                ]);
                return;
            }
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['featured_image' => 'Please select an image']
            ]);
            return;
        }

        // Save event
        $this->load->model('event_model');
        $event_id = $this->event_model->add_event($eventData);

        if ($event_id) {
            $this->session->set_flashdata('message', 'event added successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('event-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to save event, try again.']
            ]);
        }
    }
    public function delete_event($id)
    {
        $this->load->model('event_model');
        $this->event_model->delete_event($id);
        $this->session->set_flashdata('message', 'event delete successfully');
        redirect(base_url('event-list'));

    }
    public function set_status($id)
    {
        $this->load->model('event_model');
        $new_status = $this->event_model->set_status($id);

        if ($new_status) {
            $this->session->set_flashdata('message', "event $new_status successfully");
        } else {
            $this->session->set_flashdata('message', "event not found");
        }

        redirect(base_url('event-list'));
    }


    public function edit_event($id)
    {
        $this->load->model('event_model');
        $data['event'] = $this->event_model->get_event_by_id($id);
        $this->load->view('admin/edit-event', $data);
    }


    public function update_event()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('title', 'Title', 'required|trim');
        $this->form_validation->set_rules('hindi_title', 'Hindi Title', 'required|trim');
        $this->form_validation->set_rules('slug', 'Slug', 'required|trim');
        $this->form_validation->set_rules('hindi_slug', 'Hindi Slug', 'required|trim');
        $this->form_validation->set_rules('content', 'Content', 'required|trim');
        $this->form_validation->set_rules('hindi_content', 'Hindi Content', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'title' => form_error('title'),
                'hindi_title' => form_error('hindi_title'),
                'slug' => form_error('slug'),
                'hindi_slug' => form_error('hindi_slug'),
                'content' => form_error('content'),
                'hindi_content' => form_error('hindi_content'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        // Get event ID
        $id = $this->input->post('id');

        // Prepare updated data
        $eventData = [
            'title' => $this->input->post('title'),
            'hindi_title' => $this->input->post('hindi_title'),
            'slug' => $this->input->post('slug'),
            'hindi_slug' => $this->input->post('hindi_slug'),
            'content' => $this->input->post('content'),
            'hindi_content' => $this->input->post('hindi_content'),
        ];

        // Upload folder config
        $uploadPath = './uploads/event/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config['upload_path'] = $uploadPath;
        $config['allowed_types'] = 'jpg|jpeg|png|webp|gif|svg';
        $config['max_size'] = 5120; // 5MB
        $config['encrypt_name'] = TRUE;

        $this->load->library('upload', $config);

        // Load model
        $this->load->model('event_model');

        // Get old image to delete if replaced
        $oldevent = $this->event_model->get_event_by_id($id);
        $oldImage = $oldevent ? $oldevent->featured_image : '';

        // ✅ If new image uploaded, replace old one
        if (!empty($_FILES['featured_image']['name'])) {
            if ($this->upload->do_upload('featured_image')) {
                $uploadData = $this->upload->data();
                $eventData['featured_image'] = 'uploads/event/' . $uploadData['file_name'];

                // Delete old image (if exists)
                if (!empty($oldImage) && file_exists('./' . $oldImage)) {
                    unlink('./' . $oldImage);
                }
            } else {
                echo json_encode([
                    'status' => 'error',
                    'errors' => ['featured_image' => $this->upload->display_errors('', '')]
                ]);
                return;
            }
        }

        // ✅ Update event
        $updated = $this->event_model->update_event($id, $eventData);

        if ($updated) {
            $this->session->set_flashdata('message', 'event updated successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('event-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to update event, please try again.']
            ]);
        }
    }
}