<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Report_model extends CI_Model
{

    public function add_report($data)
    {
        $this->db->insert('reports', $data);
        return $this->db->insert_id();
    }
    public function get_all()
    {
        $this->db->order_by('id', 'desc');
        return $this->db->get('reports')->result();
    }

    public function update_report($id, $data)
    {
        $this->db->where('id', $id);
        // db->update returns boolean true/false in CI
        return $this->db->update('reports', $data);
    }

    public function get_report_by_id($id)
    {
        $this->db->where('id', $id);
        return $this->db->get('reports')->row();
    }


    public function delete_report($id)
    {
        // Step 1: Fetch file path from DB
        $this->db->select('featured_file');
        $this->db->from('reports');
        $this->db->where('id', $id);
        $query = $this->db->get();
        $row = $query->row();

        // Step 2: Delete image file if it exists
        if (!empty($row) && !empty($row->featured_file)) {
            $image_path = FCPATH . $row->featured_file;
            if (file_exists($image_path)) {
                unlink($image_path); // Delete the file from folder
            }
        }

        // Step 3: Delete record from database
        $this->db->where('id', $id);
        $this->db->delete('reports');

        // Step 4: Optional - return status
        if ($this->db->affected_rows() > 0) {
            return true; // Deleted successfully
        } else {
            return false; // Something went wrong
        }
    }
}