<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Add Course | Hope Harbor Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php include_once('common_page/links.php'); ?>
</head>

<body>
    <!-- Begin page -->
    <div class="wrapper">

        <?php include_once('common_page/sidebar.php'); ?>
        <?php include_once('common_page/header.php'); ?>

        <!-- ============================================================== -->
        <!-- Start Main Content -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="container-fluid">
                <div class="page-title-head d-flex align-items-center">
                    <div class="flex-grow-1">
                        <h4 class="fs-xl fw-bold m-0">Add Course</h4>
                    </div>


                </div>


                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header justify-content-between">
                                <h4 class="card-title">Add Course</h4>
                            </div>

                            <div class="card-body">
                                <form class="row g-3 needs-validation" id="courseForm" method="POST"
                                    enctype="multipart/form-data" novalidate>
                                    <div class="col-md-6">
                                        <label for="validationCustom03" class="form-label">Category</label>
                                        <select name="course_category" id="validationCustom03" class="form-select">
                                            <option value="">Select Category</option>
                                            <?php foreach ($category as $data): ?>
                                                <option value="<?= $data->category ?>"
                                                    data-hindi="<?= $data->hindi_category ?>">
                                                    <?= $data->category ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="valid-feedback"> Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid category.</div>
                                        <span id="error-course_category" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="validationCustom04" class="form-label">Hindi Category</label>
                                        <select name="hindi_course_category" id="validationCustom04"
                                            class="form-select">
                                            <option value="">Select Category</option>
                                            <?php foreach ($category as $data): ?>
                                                <option value="<?= $data->hindi_category ?>"><?= $data->hindi_category ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="valid-feedback"> Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid category.</div>
                                        <span id="error-hindi_course_category" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="validationCustom02" class="form-label">Course Name</label>
                                        <input type="text" class="form-control" id="validationCustom02"
                                            name="course_name" required>
                                        <div class="valid-feedback"> Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Course Name.</div>
                                        <span id="error-course_name" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="validationCustom02" class="form-label">Hindi Course Name</label>
                                        <input type="text" class="form-control" id="validationCustom02"
                                            name="hindi_course_name" required>
                                        <div class="valid-feedback"> Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Hindi Course Name.</div>
                                        <span id="error-hindi_course_name" class="text-danger error"></span>
                                    </div>
                                    <div id="subjectWrapper">

                                        <div class="row mt-2 align-items-center subject-row">
                                            <div class="col-md-5">
                                                <label class="form-label">Subject</label>
                                                <input type="text" class="form-control" name="subject[]" required>
                                                <div class="valid-feedback">Looks great!</div>
                                                <div class="invalid-feedback">Please choose a valid Subject.</div>
                                            </div>

                                            <div class="col-md-5">
                                                <label class="form-label">Hindi Subject</label>
                                                <input type="text" class="form-control" name="hindi_subject[]" required>
                                                <div class="valid-feedback">Looks great!</div>
                                                <div class="invalid-feedback">Please choose a valid Hindi Subject.</div>
                                            </div>

                                            <div class="col-md-2 mt-3">
                                                <button type="button"
                                                    class="btn btn-primary btn-small add-row">+</button>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <button class="btn btn-primary" type="submit">Submit Form</button>
                                    </div>
                                </form>

                            </div> <!-- end card-body-->
                        </div> <!-- end card-->
                    </div>
                </div>



            </div>
            <!-- container -->

            <?php include_once('common_page/footer.php'); ?>


        </div>

        <!-- ============================================================== -->
        <!-- End of Main Content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <?php include_once('common_page/script.php'); ?>


    <script>
        $(document).ready(function () {

            // ================================
            // ADD NEW ROW (+ button)
            // ================================
            $(document).on("click", ".add-row", function () {

                let html = `
        <div class="row mt-3 align-items-center subject-row">
            
            <div class="col-md-5">
                <input type="text" class="form-control" name="subject[]" placeholder="Subject" required>
                <span class="text-danger error error-subject"></span>
            </div>

            <div class="col-md-5">
                <input type="text" class="form-control" name="hindi_subject[]" placeholder="Hindi Subject" required>
                <span class="text-danger error error-hindi_subject"></span>
            </div>

            <div class="col-md-2 mt-2">
                <button type="button" class="btn btn-danger btn-small remove-row">−</button>
            </div>

        </div>
        `;

                $("#subjectWrapper").append(html);
            });

            // ================================
            // REMOVE ROW
            // ================================
            $(document).on("click", ".remove-row", function () {
                $(this).closest(".subject-row").remove();
            });

            // ================================
            // FORM SUBMIT AJAX
            // ================================
            $("#courseForm").on("submit", function (e) {
                e.preventDefault();
                $(".error").html("");

                const formData = new FormData(this);

                $.ajax({
                    url: "<?= base_url('admin/courses/submit_course') ?>",
                    type: "POST",
                    data: formData,
                    contentType: false,
                    processData: false,
                    dataType: "json",

                    success: function (response) {

                        if (response.status === "error") {

                            $.each(response.errors, function (key, val) {

                                if (key === "subject" || key === "hindi_subject") {

                                    $("[name='" + key + "[]']").each(function (index) {
                                        $(this).closest(".col-md-5").find(".error").html(val[index] || "");
                                    });

                                } else {
                                    $("#error-" + key).html(val);
                                }

                            });

                        } else if (response.status === "success") {
                            window.location.href = response.redirect;
                        }
                    },

                    error: function (xhr) {
                        console.log("AJAX Error:", xhr.responseText);
                    }
                });
            });

        });
    </script>




    <script>
        document.getElementById("validationCustom03").addEventListener("change", function () {
            let selectedOption = this.options[this.selectedIndex];
            let hindiValue = selectedOption.getAttribute("data-hindi");

            if (hindiValue) {
                document.getElementById("validationCustom04").value = hindiValue;
            }
        });
    </script>



</body>

</html>