<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Video Gallery | Hope Harbor Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php include_once('common_page/links.php'); ?>
</head>

<body>
    <!-- Begin page -->
    <div class="wrapper">

        <?php include_once('common_page/sidebar.php'); ?>
        <?php include_once('common_page/header.php'); ?>

        <!-- ============================================================== -->
        <!-- Start Main Content -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="container-fluid">
                <div class="page-title-head d-flex align-items-center">
                    <div class="flex-grow-1">
                        <h4 class="fs-xl fw-bold m-0">Video Gallery</h4>
                    </div>

                    <div class="text-end">
                        <a href="<?= base_url('add-video-gallery') ?>" class="btn btn-soft-secondary">
                            Add Video Gallery &nbsp;
                            <i class="fa-solid fa-arrow-right"></i>
                        </a>
                    </div>
                </div>


                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header justify-content-between">
                                <h4 class="card-title"> Video Gallery DataTable </h4>
                            </div>
                            <div class="card-body">
                                <table data-tables="basic" class="table table-striped dt-responsive align-middle mb-0">
                                    <thead class="thead-sm text-uppercase fs-xxs">
                                        <tr>
                                            <th>s. No.</th>
                                            <th>VIdeo Link</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $i = 1;
                                        foreach ($videos as $data): ?>
                                            <tr>
                                                <td><?= $i++ ?></td>
                                                <td>
                                                    <a href="<?= $data->video_link ?>"
                                                        target="_blank"><?= $data->video_link ?></a>
                                                </td>
                                                <td><?= $data->status ?></td>
                                                <td>
                                                    <div class="d-flex gap-1">

                                                        <?php if ($data->status == 'active'): ?>
                                                            <a href="<?= base_url('admin/video_gallery/set_status/' . $data->id) ?>"
                                                                class="btn btn-light btn-icon btn-sm rounded-circle"><i
                                                                    class="ti ti-eye fs-lg"></i></a>
                                                        <?php else: ?>
                                                            <a href="<?= base_url('admin/video_gallery/set_status/' . $data->id) ?>"
                                                                class="btn btn-danger btn-icon btn-sm rounded-circle"><i
                                                                    class="ti ti-eye-off fs-lg"></i></a>
                                                        <?php endif; ?>
                                                        <a href="<?= base_url('admin/video_gallery/delete_video_gallery/' . $data->id) ?>"
                                                            data-table-delete-row
                                                            class="btn btn-danger btn-icon btn-sm rounded-circle"><i
                                                                class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div> <!-- end card-body-->
                        </div> <!-- end card-->
                    </div>
                </div>



            </div>
            <!-- container -->

            <?php if ($this->session->flashdata('message')): ?>
                <div class="toast-container position-fixed top-0 end-0 p-3" style="z-index: 9999">
                    <div id="flashToast" class="toast align-items-center text-bg-success border-0 shadow-lg mt-3"
                        role="alert" aria-live="assertive" aria-atomic="true">
                        <div class="d-flex">
                            <div class="toast-body fw-semibold">
                                <?= $this->session->flashdata('message'); ?>
                            </div>
                            <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"
                                aria-label="Close"></button>
                        </div>
                    </div>
                </div>

                <script>
                    document.addEventListener("DOMContentLoaded", function () {
                        var toastEl = document.getElementById('flashToast');
                        var toast = new bootstrap.Toast(toastEl, { delay: 3000 });
                        toast.show();
                    });
                </script>
            <?php endif; ?>

            <?php include_once('common_page/footer.php'); ?>


        </div>

        <!-- ============================================================== -->
        <!-- End of Main Content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <?php include_once('common_page/script.php'); ?>


</body>

</html>