<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Blog extends MY_Controller
{
    public function index()
    {
        $this->load->model('blog_model');

        // Get category safely
        $category = $this->input->get('category');
        if (!empty($category)) {
            $category = urldecode($category);
        }

        $data['category'] = $this->blog_model->get_all_category();

        if (!empty($category)) {
            $data['blog'] = $this->blog_model->get_blogs_by_category($category);
        } else {
            $data['blog'] = $this->blog_model->get_all();
        }

        $this->load->view('blog', $data);
    }

    public function blog_details($slug)
    {
        $this->load->model('blog_model');
        $slug = $slug ? urldecode($slug) : '';

        $data['category'] = $this->blog_model->get_all_category();
        $data['details'] = $this->blog_model->get_blog_by_slug($slug);
        $data['blog'] = $this->blog_model->get_all();
        // Related blogs (same category, limit 2, exclude current)
        $data['related'] = $this->blog_model->get_related(
            $data['details']->category,
            $data['details']->id
        );
        $this->load->view('blog-details', $data);
    }
}