<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Courses extends CI_Controller
{
    public function index()
    {
        $this->load->model('course_model');
        $data['category'] = $this->course_model->get_all_category();
        $this->load->view('admin/courses-category', $data);
    }
    public function add_courses_category()
    {
        $this->load->view('admin/add-courses-category');
    }

    public function submit_courses_category()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('category', 'Category', 'required|trim');
        $this->form_validation->set_rules('hindi_category', 'Hindi Category', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'category' => form_error('category'),
                'hindi_category' => form_error('hindi_category'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        $courseCategory = [
            'category' => $this->input->post('category'),
            'hindi_category' => $this->input->post('hindi_category'),
        ];

        $this->load->model('course_model');
        $insert_id = $this->course_model->add_course_category($courseCategory);

        if ($insert_id) {
            $this->session->set_flashdata('message', 'Course Category added successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('courses-category-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to save Course Category, try again.']
            ]);
        }
    }

    public function edit_course_category($id)
    {
        $this->load->model('course_model');
        $data['category'] = $this->course_model->get_course_category_by_id($id);
        $this->load->view('admin/edit-courses-category', $data);
    }

    public function update_course_category()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('category', 'Category', 'required|trim');
        $this->form_validation->set_rules('hindi_category', 'Hindi Category', 'required|trim');
        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'category' => form_error('category'),
                'hindi_category' => form_error('hindi_category'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        // Get course ID
        $id = $this->input->post('id');

        // Prepare updated data
        $categoryData = [
            'category' => $this->input->post('category'),
            'hindi_category' => $this->input->post('hindi_category'),
        ];

        // Upload folder config


        // Load model
        $this->load->model('course_model');
        // ✅ Update course
        $updated = $this->course_model->update_course_category($id, $categoryData);

        if ($updated) {
            $this->session->set_flashdata('message', 'Course Category updated successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('courses-category-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to update Course Category, please try again.']
            ]);
        }
    }

    public function delete_course_category($id)
    {
        $this->load->model('course_model');
        $this->course_model->delete_course_category($id);
        $this->session->set_flashdata('message', 'Course Category delete successfully');
        redirect(base_url('courses-category-list'));

    }

    public function courses_list()
    {
        $this->load->model('course_model');
        $data['course'] = $this->course_model->get_all();
        $this->load->view('admin/courses', $data);
    }

    public function add_courses()
    {
        $this->load->model('course_model');
        $data['category'] = $this->course_model->get_all_category();
        $this->load->view('admin/add-courses', $data);
    }


    public function submit_course()
    {
        $this->load->model('Course_model');

        // ================================
        // NORMAL FIELDS VALIDATION
        // ================================
        $this->form_validation->set_rules('course_category', 'Category', 'required');
        $this->form_validation->set_rules('hindi_course_category', 'Hindi Category', 'required');
        $this->form_validation->set_rules('course_name', 'Course Name', 'required');
        $this->form_validation->set_rules('hindi_course_name', 'Hindi Course Name', 'required');

        // ================================
        // DYNAMIC SUBJECT VALIDATION
        // ================================
        $subjects = $this->input->post('subject');
        $hindi_subjects = $this->input->post('hindi_subject');

        $errors = [];
        $status = "success";

        // FIRST validate non-array fields using CI
        if ($this->form_validation->run() === FALSE) {

            $status = "error";

            $errors['course_category'] = form_error('course_category');
            $errors['hindi_course_category'] = form_error('hindi_course_category');
            $errors['course_name'] = form_error('course_name');
            $errors['hindi_course_name'] = form_error('hindi_course_name');
        }

        // ================================
        // ARRAY FIELD VALIDATION (manual)
        // ================================
        foreach ($subjects as $key => $sub) {
            if (trim($sub) == "") {
                $status = "error";
                $errors['subject'][$key] = "Subject required";
            }
        }

        foreach ($hindi_subjects as $key => $sub2) {
            if (trim($sub2) == "") {
                $status = "error";
                $errors['hindi_subject'][$key] = "Hindi Subject required";
            }
        }

        // ================================
        // RETURN ERRORS IF ANY
        // ================================
        if ($status === "error") {
            echo json_encode([
                "status" => "error",
                "errors" => $errors
            ]);
            exit;
        }

        // ================================
        // SAVE COURSE + SUBJECTS
        // ================================
        $courseData = [
            'course_category' => $this->input->post('course_category'),
            'hindi_course_category' => $this->input->post('hindi_course_category'),
            'course_name' => $this->input->post('course_name'),
            'hindi_course_name' => $this->input->post('hindi_course_name'),
        ];

        $course_id = $this->Course_model->submit_course(
            $courseData,
            $subjects,
            $hindi_subjects
        );

        echo json_encode([
            "status" => "success",
            'message' => 'Course add successfully!',
            "redirect" => base_url("courses-list")
        ]);
        $this->session->set_flashdata('message', 'Course added successfully!');
    }

    public function edit_course($id)
    {
        $this->load->model('Course_model');
        $data['course'] = $this->Course_model->get_course_by_id($id);
        $data['category'] = $this->Course_model->get_all_category();
        $this->load->view('admin/edit-courses', $data);
    }

    public function update_course()
    {
        $this->load->model('Course_model');

        $id = $this->input->post('id');

        $updateData = [
            'course_category' => $this->input->post('course_category'),
            'hindi_course_category' => $this->input->post('hindi_course_category'),
            'course_name' => $this->input->post('course_name'),
            'hindi_course_name' => $this->input->post('hindi_course_name'),
        ];

        $subject = $this->input->post('subject');
        $hindi_subject = $this->input->post('hindi_subject');

        // VALIDATION
        $errors = [];

        if (empty($updateData['course_category'])) {
            $errors['course_category'] = "Category is required";
        }
        if (empty($updateData['hindi_course_category'])) {
            $errors['hindi_course_category'] = "Hindi Category is required";
        }
        if (empty($updateData['course_name'])) {
            $errors['course_name'] = "Course name required";
        }
        if (empty($updateData['hindi_course_name'])) {
            $errors['hindi_course_name'] = "Hindi course name required";
        }

        // SUBJECT VALIDATION
        foreach ($subject as $i => $sub) {
            if (empty($sub)) {
                $errors['subject'][$i] = "Subject required";
            }
            if (empty($hindi_subject[$i])) {
                $errors['hindi_subject'][$i] = "Hindi Subject required";
            }
        }

        if (!empty($errors)) {
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        // UPDATE MAIN COURSE
        $this->Course_model->update_course($id, $updateData);

        // SUBJECT UPDATE
        $this->Course_model->update_subjects($id, $subject, $hindi_subject);

        echo json_encode([
            'status' => 'success',
            'message' => 'Course updated successfully!',
            'redirect' => base_url('courses-list')
        ]);
        $this->session->set_flashdata('message', 'Course updated successfully!');
    }


    public function delete_course($id)
    {
        $this->load->model('Course_model');
        $this->Course_model->delete_course_category($id);
        $this->session->set_flashdata('message', 'Course delete successfully');
        redirect(base_url('courses-list'));

    }


}