<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Gallery extends CI_Controller
{

    public function gallery_category()
    {
        $this->load->model('gallery_model');
        $data['category'] = $this->gallery_model->get_all_category();
        $this->load->view('admin/gallery-category', $data);
    }

    public function add_gallery_category()
    {
        $this->load->view('admin/add-gallery-category');
    }

    public function submit_gallery_category()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('category', 'Category', 'required|trim');
        $this->form_validation->set_rules('hindi_category', 'Hindi Category', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'category' => form_error('category'),
                'hindi_category' => form_error('hindi_category'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        $galleryCategory = [
            'category' => $this->input->post('category'),
            'hindi_category' => $this->input->post('hindi_category'),
        ];

        $this->load->model('gallery_model');
        $insert_id = $this->gallery_model->add_gallery_category($galleryCategory);

        if ($insert_id) {
            $this->session->set_flashdata('message', 'Gallery Category added successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('gallery-category')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to save Gallery Category, try again.']
            ]);
        }
    }

    public function edit_gallery_category($id)
    {
        $this->load->model('gallery_model');
        $data['category'] = $this->gallery_model->get_gallery_category_by_id($id);
        $this->load->view('admin/edit-gallery-category', $data);
    }


    public function update_gallery_category()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('category', 'Category', 'required|trim');
        $this->form_validation->set_rules('hindi_category', 'Hindi Category', 'required|trim');
        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'category' => form_error('category'),
                'hindi_category' => form_error('hindi_category'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        // Get blog ID
        $id = $this->input->post('id');

        // Prepare updated data
        $categoryData = [
            'category' => $this->input->post('category'),
            'hindi_category' => $this->input->post('hindi_category'),
        ];

        // Upload folder config


        // Load model
        $this->load->model('gallery_model');
        // ✅ Update blog
        $updated = $this->gallery_model->update_gallery_category($id, $categoryData);

        if ($updated) {
            $this->session->set_flashdata('message', 'Gallery Category updated successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('gallery-category')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to update Gallery Category, please try again.']
            ]);
        }
    }

    public function index()
    {
        $this->load->model('gallery_model');
        $data['gallery'] = $this->gallery_model->get_all();
        $this->load->view('admin/gallery', $data);
    }
    public function add_gallery()
    {
        $this->load->model('gallery_model');
        $data['category'] = $this->gallery_model->get_all_category();
        $this->load->view('admin/add-gallery', $data);
    }

    public function submit_gallery()
    {
        $this->load->model('Gallery_model');
        $this->load->library('upload');
        $this->load->library('form_validation');

        $response = ['status' => 'error', 'errors' => []];

        // ✅ Validation (normal name, not array)
        $this->form_validation->set_rules('gallery_category[]', 'Gallery Category', 'required|trim');
        $this->form_validation->set_rules('hindi_gallery_category[]', 'Hindi Gallery Category', 'required|trim');
        $this->form_validation->set_rules('year[]', 'Year', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $response['errors']['gallery_category'] = form_error('gallery_category[]', '', '');
            $response['errors']['hindi_gallery_category'] = form_error('hindi_gallery_category[]', '', '');
            $response['errors']['year'] = form_error('year[]', '', '');
            echo json_encode($response);
            return;
        }

        // ✅ Get selected values
        $gallery_category = $this->input->post('gallery_category')[0];
        $hindi_gallery_category = $this->input->post('hindi_gallery_category')[0];
        $year = $this->input->post('year')[0];

        // ✅ Validate images
        if (!isset($_FILES['gallery_image']) || empty($_FILES['gallery_image']['name'][0])) {
            $response['errors']['image'] = 'Please upload at least one image.';
            echo json_encode($response);
            return;
        }

        // ✅ Upload path
        $upload_path = './uploads/gallery/';
        if (!is_dir($upload_path)) {
            mkdir($upload_path, 0777, true);
        }

        $uploaded_files = [];
        $filesCount = count($_FILES['gallery_image']['name']);

        for ($i = 0; $i < $filesCount; $i++) {
            $_FILES['file']['name'] = $_FILES['gallery_image']['name'][$i];
            $_FILES['file']['type'] = $_FILES['gallery_image']['type'][$i];
            $_FILES['file']['tmp_name'] = $_FILES['gallery_image']['tmp_name'][$i];
            $_FILES['file']['error'] = $_FILES['gallery_image']['error'][$i];
            $_FILES['file']['size'] = $_FILES['gallery_image']['size'][$i];

            $config = [
                'upload_path' => $upload_path,
                'allowed_types' => 'jpg|jpeg|png|gif',
                'max_size' => 51200,
                'encrypt_name' => TRUE
            ];

            $this->upload->initialize($config);

            if ($this->upload->do_upload('file')) {
                $uploadData = $this->upload->data();
                $uploaded_files[] = 'uploads/gallery/' . $uploadData['file_name'];
            }
        }

        if (empty($uploaded_files)) {
            $response['errors']['image'] = 'Failed to upload images.';
            echo json_encode($response);
            return;
        }

        // ✅ Insert each image into DB
        $all_inserted = true;
        foreach ($uploaded_files as $img) {
            $save = $this->Gallery_model->insert_gallery($gallery_category, $hindi_gallery_category, $img, $year);
            if (!$save)
                $all_inserted = false;
        }

        if ($all_inserted) {
            $response = [
                'status' => 'success',
                'message' => 'Gallery added successfully!',
                'redirect' => base_url('admin/gallery')
            ];
        } else {
            $response['errors']['image'] = 'Failed to save some images.';
        }

        echo json_encode($response);
    }

    public function edit_gallery($id)
    {
        $this->load->model('gallery_model');
        $data['gallery'] = $this->gallery_model->get_gallery_by_id($id);
        $this->load->view('admin/edit-gallery', $data);
    }

    public function update_gallery()
    {
        $this->form_validation->set_error_delimiters('', '');

        // ✅ Validation rules
        $this->form_validation->set_rules('gallery_category', 'Gallery Category', 'required|trim');
        $this->form_validation->set_rules('hindi_gallery_category', 'Hindi Gallery Category', 'required|trim');
        $this->form_validation->set_rules('year', 'Year', 'required|trim|exact_length[4]|numeric');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'gallery_category' => form_error('gallery_category'),
                'hindi_gallery_category' => form_error('hindi_gallery_category'),
                'year' => form_error('year'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        // ✅ Get gallery ID
        $id = $this->input->post('id');

        // ✅ Prepare update data
        $galleryData = [
            'gallery_category' => $this->input->post('gallery_category'),
            'hindi_gallery_category' => $this->input->post('hindi_gallery_category'),
            'year' => $this->input->post('year'),
        ];

        // ✅ Upload folder config
        $uploadPath = './uploads/gallery/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config['upload_path'] = $uploadPath;
        $config['allowed_types'] = 'jpg|jpeg|png|webp|gif|svg';
        $config['max_size'] = 5120; // 5 MB
        $config['encrypt_name'] = TRUE;

        $this->load->library('upload', $config);

        // ✅ Load model
        $this->load->model('gallery_model');

        // ✅ Get old image for deletion if replaced
        $oldGallery = $this->gallery_model->get_gallery_by_id($id);
        $oldImage = $oldGallery ? $oldGallery->gallery_image : '';

        // ✅ If new image uploaded, replace the old one
        if (!empty($_FILES['gallery_image']['name'])) {
            if ($this->upload->do_upload('gallery_image')) {
                $uploadData = $this->upload->data();
                $galleryData['gallery_image'] = 'uploads/gallery/' . $uploadData['file_name'];

                // Delete old image if exists
                if (!empty($oldImage) && file_exists('./' . $oldImage)) {
                    unlink('./' . $oldImage);
                }
            } else {
                echo json_encode([
                    'status' => 'error',
                    'errors' => ['image' => $this->upload->display_errors('', '')]
                ]);
                return;
            }
        }

        // ✅ Update gallery record
        $updated = $this->gallery_model->update_gallery($id, $galleryData);

        if ($updated) {
            $this->session->set_flashdata('message', 'Gallery updated successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('gallery-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to update gallery, please try again.']
            ]);
        }
    }




    public function delete_gallery($id)
    {
        $this->load->model('Gallery_model');
        $this->Gallery_model->delete_gallery($id);
        $this->session->set_flashdata('message', 'Gallery Image delete successfully');
        redirect(base_url('gallery-list'));

    }


}