<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Partner extends CI_Controller
{
    public function index()
    {
        $this->load->model('partner_model');
        $data['partner'] = $this->partner_model->get_all();
        $this->load->view('admin/partner', $data);
        // $this->load->view('admin/partner', );
    }
    public function add_partner()
    {
        $this->load->view('admin/add-partner');
    }

    public function submit_partner()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('name', 'Name', 'required|trim');
        $this->form_validation->set_rules('web_link', 'Website Link', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'name' => form_error('name'),
                'web_link' => form_error('web_link'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        $partnerData = [
            'name' => $this->input->post('name'),
            'web_link' => $this->input->post('web_link'),
        ];

        // Upload folder config
        $uploadPath = './uploads/partner/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config['upload_path'] = $uploadPath;
        $config['allowed_types'] = 'jpg|jpeg|png|webp|gif|svg';
        $config['max_size'] = 5120; // 5MB
        $config['encrypt_name'] = TRUE;

        $this->load->library('upload', $config);

        if (!empty($_FILES['featured_image']['name'])) {
            if ($this->upload->do_upload('featured_image')) {
                $uploadData = $this->upload->data();
                $partnerData['featured_image'] = 'uploads/partner/' . $uploadData['file_name'];
            } else {
                echo json_encode([
                    'status' => 'error',
                    'errors' => ['featured_image' => $this->upload->display_errors('', '')]
                ]);
                return;
            }
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['featured_image' => 'Please select an image']
            ]);
            return;
        }

        // Save blog
        $this->load->model('partner_model');
        $partner_id = $this->partner_model->add_partner($partnerData);

        if ($partner_id) {
            $this->session->set_flashdata('message', 'partner Member added successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('partner-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to save partner Member, try again.']
            ]);
        }
    }

    public function edit_partner($id)
    {
        $this->load->model('partner_model');
        $data['partner'] = $this->partner_model->get_partner_by_id($id);
        $this->load->view('admin/edit-partner', $data);
    }


    public function update_partner()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('name', 'Name', 'required|trim');
        $this->form_validation->set_rules('hindi_name', 'Name', 'required|trim');
        $this->form_validation->set_rules('email', 'Email', 'required|trim');
        $this->form_validation->set_rules('phone', 'Phone', 'required|trim');
        $this->form_validation->set_rules('designation', 'Designation', 'required|trim');
        $this->form_validation->set_rules('hindi_designation', 'Hindi Designation', 'required|trim');
        $this->form_validation->set_rules('content', 'Content', 'required|trim');
        $this->form_validation->set_rules('hindi_content', 'Hindi Content', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'name' => form_error('name'),
                'hindi_name' => form_error('hindi_name'),
                'email' => form_error('email'),
                'phone' => form_error('phone'),
                'designation' => form_error('designation'),
                'hindi_designation' => form_error('hindi_designation'),
                'content' => form_error('content'),
                'hindi_content' => form_error('hindi_content'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        // Get blog ID
        $id = $this->input->post('id');

        // Prepare updated data
        $partnerData = [
            'name' => $this->input->post('name'),
            'hindi_name' => $this->input->post('hindi_name'),
            'email' => $this->input->post('email'),
            'phone' => $this->input->post('phone'),
            'designation' => $this->input->post('designation'),
            'hindi_designation' => $this->input->post('hindi_designation'),
            'content' => $this->input->post('content'),
            'hindi_content' => $this->input->post('hindi_content'),
        ];

        // Upload folder config
        $uploadPath = './uploads/partner/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config['upload_path'] = $uploadPath;
        $config['allowed_types'] = 'jpg|jpeg|png|webp|gif|svg';
        $config['max_size'] = 5120; // 5MB
        $config['encrypt_name'] = TRUE;

        $this->load->library('upload', $config);

        // Load model
        $this->load->model('partner_model');

        // Get old image to delete if replaced
        $oldpartner = $this->partner_model->get_partner_by_id($id);
        $oldImage = $oldpartner ? $oldpartner->featured_image : '';

        // ✅ If new image uploaded, replace old one
        if (!empty($_FILES['featured_image']['name'])) {
            if ($this->upload->do_upload('featured_image')) {
                $uploadData = $this->upload->data();
                $partnerData['featured_image'] = 'uploads/partner/' . $uploadData['file_name'];

                // Delete old image (if exists)
                if (!empty($oldImage) && file_exists('./' . $oldImage)) {
                    unlink('./' . $oldImage);
                }
            } else {
                echo json_encode([
                    'status' => 'error',
                    'errors' => ['featured_image' => $this->upload->display_errors('', '')]
                ]);
                return;
            }
        }

        // ✅ Update blog
        $updated = $this->partner_model->update_partner($id, $partnerData);

        if ($updated) {
            $this->session->set_flashdata('message', 'partner Member updated successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('partner-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to update partner Member, please try again.']
            ]);
        }
    }

    public function delete_partner($id)
    {
        $this->load->model('partner_model');
        $this->partner_model->delete_partner($id);
        $this->session->set_flashdata('message', 'partner Member delete successfully');
        redirect(base_url('partner-list'));

    }

}