<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Course_model extends CI_Model
{

    public function add_course_category($data)
    {
        $this->db->insert('courses_category', $data);
        if ($this->db->affected_rows() > 0) {
            return $this->db->insert_id(); // return insert ID
        } else {
            return false;
        }
    }

    public function get_all_category()
    {
        $this->db->order_by('id', 'desc');
        return $this->db->get('courses_category')->result();
    }

    public function get_course_category_by_id($id)
    {
        $this->db->where('id', $id);
        return $this->db->get('courses_category')->row();
    }

    public function update_course_category($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('courses_category', $data);
    }

    public function delete_course_category($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('courses_category');
        return $this->db->affected_rows();
    }

    public function submit_course($data, $subjects, $hindi_subjects)
    {
        $this->db->insert('courses', $data);
        $course_id = $this->db->insert_id();

        // Insert subjects into separate table
        foreach ($subjects as $i => $sub) {

            $rowData = [
                'course_id' => $course_id,
                'subject' => $subjects[$i],
                'hindi_subject' => $hindi_subjects[$i]
            ];

            $this->db->insert('course_subject', $rowData);
        }

        return $course_id;
    }

    public function get_all()
    {
        $this->db->select('
        courses.*,
        GROUP_CONCAT(course_subject.subject SEPARATOR ", ") AS subjects,
        GROUP_CONCAT(course_subject.hindi_subject SEPARATOR ", ") AS hindi_subjects
    ');
        $this->db->from('courses');
        $this->db->join('course_subject', 'courses.id = course_subject.course_id', 'left');
        $this->db->group_by('courses.id');
        $this->db->order_by('courses.id', 'desc');
        return $this->db->get()->result();
    }

    public function get_course_by_id($id)
    {
        // Main course details
        $this->db->select('courses.*');
        $this->db->from('courses');
        $this->db->where('courses.id', $id);
        $course = $this->db->get()->row();

        if (!$course) {
            return null;
        }

        // Subjects fetch
        $this->db->select('subject, hindi_subject');
        $this->db->from('course_subject');
        $this->db->where('course_id', $id);
        $subjects = $this->db->get()->result();

        // Convert into array format for edit form
        $course->subject = [];
        $course->hindi_subject = [];

        foreach ($subjects as $s) {
            $course->subject[] = $s->subject;
            $course->hindi_subject[] = $s->hindi_subject;
        }

        return $course;
    }

    public function update_course($id, $data)
    {
        $this->db->where('id', $id);
        $this->db->update('courses', $data);
    }

    public function update_subjects($course_id, $subject, $hindi_subject)
    {
        // Purane subject delete
        $this->db->where('course_id', $course_id);
        $this->db->delete('course_subject');

        // Naye insert
        foreach ($subject as $i => $sub) {

            $insertData = [
                'course_id' => $course_id,
                'subject' => $sub,
                'hindi_subject' => $hindi_subject[$i]
            ];

            $this->db->insert('course_subject', $insertData);
        }
    }

    public function delete_course($id)
    {
        // Delete subjects first
        $this->db->where('course_id', $id);
        $this->db->delete('course_subject');

        // Delete main course
        $this->db->where('id', $id);
        $this->db->delete('courses');

        return $this->db->affected_rows();
    }



}