<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Gallery_model extends CI_Model
{

    public function add_gallery_category($data)
    {
        $this->db->insert('gallery_category', $data);
        if ($this->db->affected_rows() > 0) {
            return $this->db->insert_id(); // return insert ID
        } else {
            return false;
        }
    }

    public function get_all_category()
    {
        $this->db->order_by('id', 'desc');
        return $this->db->get('gallery_category')->result();
    }

    public function get_gallery_category_by_id($id)
    {
        $this->db->where('id', $id);
        return $this->db->get('gallery_category')->row();
    }

    public function update_gallery_category($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('gallery_category', $data);
    }

    public function insert_gallery($gallery_category, $hindi_gallery_category, $image_path, $year)
    {
        $data = [
            'gallery_category' => $gallery_category,
            'hindi_gallery_category' => $hindi_gallery_category,
            'gallery_image' => $image_path,
            'year' => $year
        ];
        return $this->db->insert('gallery', $data);
    }



    public function get_all()
    {
        $this->db->order_by('id', 'desc');
        return $this->db->get('gallery')->result();
    }

    public function get_gallery_by_id($id)
    {
        $this->db->where('id', $id);
        return $this->db->get('gallery')->row();
    }

    public function update_gallery($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('gallery', $data);
    }
    public function delete_gallery($id)
    {
        // 🔹 पहले image path निकालो
        $this->db->select('gallery_image');
        $this->db->from('gallery');
        $this->db->where('id', $id);
        $query = $this->db->get();
        $row = $query->row();

        if ($row) {
            $image_path = FCPATH . $row->gallery_image; // Full path to file

            // 🔹 अगर file exist करती है तो delete कर दो
            if (file_exists($image_path)) {
                unlink($image_path);
            }

            // 🔹 अब database से row delete करो
            $this->db->where('id', $id);
            $this->db->delete('gallery');

            return $this->db->affected_rows(); // 1 return करेगा अगर delete successful हुआ
        }

        return 0; // अगर record नहीं मिला
    }


}