<?php
defined('BASEPATH') or exit('No direct script access allowed');

class News_model extends CI_Model
{

    public function add_news($data)
    {
        $this->db->insert('news', $data);
        return $this->db->insert_id();
    }
    public function get_all()
    {
        $this->db->order_by('id', 'desc');
        return $this->db->get('news')->result();
    }
    public function edit_news($id, $data)
    {
        $this->db->where('id', $id);
        $this->db->update('news', $data);
        return $this->db->affected_rows();
    }
    public function get_news_by_id($id)
    {
        $this->db->where('id', $id);
        return $this->db->get('news')->row();
    }

    public function delete_news($id)
    {
        // Step 1: Fetch file path from DB
        $this->db->select('featured_image');
        $this->db->from('news');
        $this->db->where('id', $id);
        $query = $this->db->get();
        $row = $query->row();

        // Step 2: Delete image file if it exists
        if (!empty($row) && !empty($row->featured_image)) {
            $image_path = FCPATH . $row->featured_image;
            if (file_exists($image_path)) {
                unlink($image_path); // Delete the file from folder
            }
        }

        // Step 3: Delete record from database
        $this->db->where('id', $id);
        $this->db->delete('news');

        // Step 4: Optional - return status
        if ($this->db->affected_rows() > 0) {
            return true; // Deleted successfully
        } else {
            return false; // Something went wrong
        }
    }
    public function set_status($id)
    {
        // Get current status
        $this->db->select('status');
        $this->db->from('news');
        $this->db->where('id', $id);
        $news = $this->db->get()->row();

        if ($news) {
            // Toggle status
            $new_status = ($news->status == 'active') ? 'inactive' : 'active';

            // Update status in database
            $this->db->where('id', $id);
            $this->db->update('news', ['status' => $new_status]);

            return $new_status; // return new status to controller
        }

        return false; // news not found
    }

    public function update_news($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('news', $data);
    }


    public function get_news_by_title($slug)
    {
        $this->db->where('slug', $slug);
        return $this->db->get('news')->row();
    }



}