<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Partner_model extends CI_Model
{

    public function add_partner($data)
    {
        $this->db->insert('partner', $data);
        return $this->db->insert_id();
    }
    public function get_all()
    {
        $this->db->order_by('id', 'desc');
        return $this->db->get('partner')->result();
    }

    public function edit_partner($id, $data)
    {
        $this->db->where('id', $id);
        $this->db->update('partner', $data);
        return $this->db->affected_rows();
    }
    public function get_partner_by_id($id)
    {
        $this->db->where('id', $id);
        return $this->db->get('partner')->row();
    }
    public function delete_partner($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('partner');
        return $this->db->affected_rows();
    }

    public function update_partner($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('partner', $data);
    }

    public function get_all_partner()
    {

        return $this->db->get('partner')->result();
    }

    public function get_partner_by_name($name)
    {
        $this->db->where('name', $name);
        return $this->db->get('partner')->row();
    }
}